using DifferentialEquations
using Random
using Statistics
using OrdinaryDiffEq
using Lux 
using DiffEqFlux
using ComponentArrays 
using Optimization, OptimizationOptimJL, OptimizationOptimisers                                                                   
rng = Random.default_rng()
Random.seed!(99)



dudt2 = Lux.Chain(Lux.Dense(2, 80, tanh),Lux.Dense(80, 80, tanh), Lux.Dense(80, 2))
#Setting up the NN parameters randomly using the rng instance
p, st = Lux.setup(rng, dudt2)

#Initial Conditions
I = [1, 0]   #Psi(0)=1, Psi'(0)=1
etaspan = (0.05, 5.325)

#radius range
datasize= 100
etasteps = range(etaspan[1], etaspan[2]; length = datasize)


prob_neuralode = NeuralODE(dudt2, etaspan, Tsit5(); saveat = etasteps)


function predict_neuralode(p)
    Array(prob_neuralode(I, p, st)[1])
end

#For no noise full data set:
p =  (layer_1 = (weight = Float32[-0.25486904 0.25164306; -0.46700332 -0.5681592; -0.28657785 -0.35588348; 0.11315492 -0.4365111; -0.24293856 0.31374368; -0.03459047 -0.5552581; 0.22921549 -0.20414479; -0.27286464 -0.33327168; -0.80317676 -0.11175246; 0.15753162 0.3949443; -0.40076163 -0.25637978; 0.20557782 -0.2479159; 0.17374937 0.37134466; 0.24307945 -0.5706925; 0.24383503 0.20684393; 0.5262217 -0.095070824; 0.3049077 -0.1089893; 0.33085912 -0.32715666; 0.22211276 0.2685694; 0.38306084 0.30170217; -0.36680484 -0.18245573; 0.44677556 0.26751626; -0.40233815 -0.21917008; 0.26264516 -0.1003251; 0.38163337 0.13325523; 0.16960056 0.18361008; -0.34905624 0.020766478; 0.11354727 0.19558705; 0.17603037 0.34677562; 0.65272313 0.63015705; 0.31509963 0.27016816; -0.28535262 -0.16749981; 0.35327825 -0.14708121; -0.42500016 0.24154133; -0.16921821 -0.54827684; 0.22987261 -0.26181734; -0.45058906 0.14658615; 0.10726205 0.3795478; 0.29681566 0.15049604; -0.09041231 -0.5234086; -0.3004075 0.04206424; -0.48919347 0.04705757; 0.056627143 -0.53513765; -0.36165425 -0.003061158; -0.20094058 0.46381173; 0.26671442 -0.18525976; -0.4967517 0.18034118; -0.32211265 -0.26221663; 0.24025053 -0.32906964; 0.3837154 0.36769307; -0.6773252 -0.015190525; 0.39862204 -0.11766503; -0.24421342 -0.35329688; 0.3384103 0.13657972; -0.31709945 -0.38689324; 0.14352515 0.29775292; 0.43604997 0.26439777; -0.5777763 0.17025259; -0.45582977 -0.057800967; 0.16469382 0.51334244; 0.14759782 0.33772284; -0.30792683 0.20470263; 0.28913787 -0.17072408; -0.007408336 0.21125041; -0.10554662 -0.38556272; 0.2991318 0.41487625; -0.12819867 -0.12998489; 0.43350345 0.39929378; -0.60229 0.07427065; 0.474978 0.52788097; 0.6397903 0.085947655; 0.3643015 -0.14150241; -0.49313352 -0.075443916; -0.07959981 -0.5230057; -0.11733917 -0.4458708; 0.27140093 0.40524358; 0.41271418 0.2615109; 0.2585737 0.25507864; -0.2867456 0.08693455; -0.1928397 -0.29752982], bias = Float32[-0.33860284; -0.29874277; 0.016474942; 0.14253154; -0.3509271; -0.051275868; 0.37766647; 0.10906374; -0.46228302; 0.042435206; -0.2892457; 0.42374447; 0.03261774; 0.15981168; -0.043533333; 0.49583477; 0.37779063; 0.467208; 0.18162867; -0.07134469; -0.03282194; 0.04061657; -0.36850065; 0.39412355; 0.5152455; -0.047584586; -0.43620896; 0.33816862; -0.0142662795; 0.4100075; 0.15200777; -0.4082128; 0.33383325; -0.5123953; -0.29727614; 0.38483167; -0.31723025; -0.020120922; 0.3467806; -0.12976864; -0.41959268; -0.4106151; 0.1862182; -0.42181978; -0.1684564; 0.4436109; -0.49271774; -0.11095356; 0.4482417; 0.13040435; -0.49056488; 0.36862096; -0.14879999; 0.37790138; -0.030432291; -0.049983017; 0.48185396; -0.3699819; -0.39641693; 0.2898828; 0.4034844; -0.31017855; 0.48714906; -0.1581684; -0.32134068; 0.25260997; 0.0016681715; 0.40040243; -0.49891296; 0.47789922; 0.485953; 0.52242446; -0.4774138; 0.022505682; -0.3070969; 0.09720652; -0.031681348; 0.0047132727; -0.38268432; -0.23326333]), layer_2 = (weight = Float32[-0.4043457 0.49186677 0.35368404 -0.25535032 -0.4681201 0.5940031 0.26871634 -0.4624962 0.50863713 0.3487335 0.0072701504 0.39278707 -0.4551757 0.11864077 0.2208475 -0.26109752 0.096424334 0.19309059 0.37923107 0.41844493 0.1236856 -0.16583338 -0.03819221 0.38876992 -0.59682727 0.3858265 -0.2974763 0.22527598 -0.23619506 -0.49467063 0.52693594 0.22401702 0.32317516 0.10341029 -0.03306424 0.47766677 -0.27114 0.18952763 -0.0025699 -0.18739337 -0.13324435 0.01600599 0.28905076 0.19132598 -0.04256672 0.28191262 0.1233542 -0.460465 0.49557397 -0.30691424 0.23534212 0.43064255 -0.4006555 -0.1528506 0.48231018 -0.20338276 -0.24389291 -0.17883392 0.34617013 -0.25333634 -0.12666829 -0.44026935 -0.07604426 0.35728645 -0.028150206 -0.52977306 -0.40015388 -0.42244986 0.48045674 -0.26265836 -0.4788915 -0.33609942 0.6260431 0.29554424 -0.1828109 0.06640804 0.2443896 0.38000935 -0.34412128 -0.25932214; -0.18863273 0.19996807 0.25590172 -0.39702284 -0.47113562 0.4480418 0.19944464 -0.1949012 0.13678135 0.39326915 0.26046008 0.18572661 -0.27356002 -0.29002717 -0.34896997 -0.17979799 0.49703258 -0.3541069 0.2818216 0.18973474 0.47813347 -0.2370871 0.33276683 0.27001643 -0.46248823 0.2620802 -0.32045144 0.2376911 -0.19322842 -0.36003128 0.25513577 -0.2782806 0.34117964 0.348269 -0.35835767 0.19544892 -0.21030305 0.24990575 -0.45004612 -0.44623595 0.45511046 -0.16252457 0.13380632 -0.20092319 0.3034962 0.11948668 0.3960067 -0.16016507 0.2687332 -0.43059993 0.14170009 0.26676422 -0.14594059 0.4373934 0.2663899 -0.26298544 -0.48663983 -0.4882485 -0.08713875 0.40165886 0.23879422 -0.40076548 -0.5503004 0.3975679 -0.44153848 -0.4158344 -0.17531565 -0.24881092 0.49456152 -0.5125327 -0.4052806 -0.33114192 0.3781182 0.22321077 -0.26363283 0.2829232 0.05363557 0.36628258 -0.45153823 -0.43479338; -0.04116699 0.15141325 -0.19425143 0.38761872 -0.09606838 0.14772613 0.25688446 -0.14653699 -0.036561444 -0.2888222 -0.32177222 0.17279825 0.22637028 0.2371592 -0.032705635 -0.15958664 -0.5100937 0.21594837 0.12272047 -0.038848184 -0.5398743 0.34955484 -0.33062056 -0.36067793 -0.21348646 0.14325851 0.28021815 -0.27993917 0.25762627 -0.013317095 -0.0101939365 0.20779726 -0.26722938 -0.54234886 0.17787471 -0.08376897 0.3360942 -0.509709 0.39642853 0.38326308 -0.21093029 0.46705556 0.18260634 0.27067897 -0.37560958 -0.00886937 -0.5482174 -0.04141904 -0.047603343 0.26395544 -0.0336888 -0.05398993 0.0028780717 -0.5174393 -0.36475357 0.37761995 0.17604971 0.4355662 0.18794052 -0.39558342 -0.23324934 0.27756628 0.46406707 -0.058399137 0.28621614 -0.0036291662 -0.122211635 0.43865398 -0.14424412 -0.18782564 0.0072618914 0.22774175 0.2448947 0.09407002 0.2902351 -0.30145663 0.28143966 -0.015249535 0.2181473 0.30661213; 0.22115438 -0.13631228 -0.09462964 0.55413705 0.070852324 0.07923116 -0.34681478 -0.26865658 -0.30882588 -0.3856362 -0.54856926 0.123219825 0.39920118 0.4049335 0.24775998 -0.10164017 -0.33683327 0.39828607 -0.07499219 0.09848911 -0.47991237 0.51058567 -0.531196 -0.47387064 -0.18682073 -0.30788204 0.56287163 -0.16188075 0.43262357 0.2355641 0.16194429 0.32634842 -0.22170636 -0.5907705 0.30263844 -0.28341332 0.6190537 -0.30156353 0.34640968 0.36652067 -0.47416592 0.5692283 -0.20509894 0.63171357 -0.4306085 0.05356478 -0.22766262 0.089622855 -0.048662577 0.30956402 -0.0530018 -0.4257652 0.15648831 -0.6057719 -0.20452926 0.49756688 0.3351471 0.48249108 0.050521903 -0.40374443 -0.5867376 0.497305 0.49043086 -0.014351675 0.4567059 0.24252313 0.12260136 0.21013005 -0.14504392 -0.10090639 0.07724043 0.4785148 -0.20600392 -0.19206515 0.39105457 -0.536609 0.30211237 -0.28035977 0.3882137 0.25562823; 0.11380259 0.1389565 0.17827901 -0.58170265 -0.029673412 -0.115557075 -0.12402223 0.16522269 0.022579322 0.41209093 0.47005707 -0.348883 -0.08413687 -0.38153717 -0.4168744 -0.035236094 0.39793003 -0.30245003 -0.20825069 -0.12906925 0.5467433 -0.31332704 0.47415265 0.524069 0.11828436 0.19596808 -0.3045427 0.22148159 -0.25972578 -0.03488879 -0.22507975 -0.37849617 0.42288032 0.5018775 -0.5126184 0.04815271 -0.469694 0.40962645 -0.60116225 -0.3638375 0.41200748 -0.32646164 -0.20739342 -0.4178303 0.48375088 -0.20750141 0.6165763 0.18793401 -0.0066020247 -0.48578167 0.2541091 0.13581383 0.143687 0.41901717 0.20607887 -0.23833676 -0.14027554 -0.2543843 -0.058150087 0.29312962 0.23727474 -0.10320967 -0.41565067 0.10410985 -0.39027792 -0.10252172 0.1287094 -0.5280369 0.23960085 -0.09058799 0.08341688 -0.45392537 0.11138623 0.16757976 -0.36140138 0.4677902 -0.21887293 0.02194134 -0.25569218 -0.07712486; 0.6079239 -0.52434474 -0.5161977 0.20929986 0.31573275 -0.25567815 -0.2536622 0.40473917 -0.24860306 -0.20881337 0.073965035 -0.26070395 0.31348413 -0.14274949 -0.0748304 0.45609182 -0.13672517 -0.08454198 -0.24201688 -0.59792316 0.24017525 -0.003484743 -0.15165018 -0.18403731 0.3905771 -0.60124093 0.021782314 -0.50540674 0.3867794 0.6101717 -0.48073795 -0.0757402 -0.23014261 0.06661653 -0.23869951 -0.29786265 0.010109451 -0.47783428 -0.13809791 0.17495438 0.08347191 0.0675258 -0.536094 -0.11276287 -0.0041636513 -0.59988534 -0.08370742 0.34294 -0.35283893 0.31231323 -0.5479146 -0.49581987 0.37330055 0.15853357 -0.34686223 0.3718155 0.20153384 0.12286635 -0.52645147 0.20897278 -0.13473353 0.26918596 -0.14051315 -0.38320482 -0.06260716 0.46485642 0.58634347 0.5066211 -0.4196779 0.31944343 0.2855668 -0.018187493 -0.325151 -0.5389056 0.17059064 -0.07699374 -0.20654584 -0.5145584 0.26777822 0.37795132; 0.39579228 -0.5206562 -0.4218644 -0.26395375 0.19454458 -0.5309351 -0.3335141 0.38637218 -0.29875848 0.08041292 0.22290215 -0.47675705 0.32222277 -0.083094604 -0.17114927 0.20681167 -0.066538885 -0.16660726 -0.29156467 -0.3198685 0.19600372 0.081712976 0.13673866 0.08927727 0.4483737 -0.21212807 -0.25170422 -0.13871412 0.019950919 0.3164387 -0.451759 -0.18123059 -0.22847778 0.039602343 -0.29550225 -0.41142583 0.07226119 -0.20637417 -0.20326465 0.053995512 0.32142994 -0.16176319 -0.30008936 -0.018222975 0.09320852 -0.43189234 0.016605712 0.20316109 -0.25867763 -0.11424808 -0.44317853 -0.24040402 0.46898308 0.032444853 -0.526966 -0.21167405 0.44555005 0.05243991 -0.399842 0.19285806 0.036927316 0.6012607 -0.2106179 -0.4514938 -0.30896038 0.35124618 0.29211813 0.46845 -0.30778155 0.2055024 0.20950367 0.035602946 -0.3721751 -0.5906102 -0.01909638 0.2592117 -0.29351094 -0.3631551 0.46340337 0.2857489; -0.4144138 0.16883183 0.39139786 0.15824313 -0.40090793 0.33740523 0.2267893 -0.12115336 0.17998074 -0.19843687 -0.32724372 0.061969176 -0.5065059 0.23721597 0.094113395 -0.19165462 -0.26841977 0.35122547 0.26755074 0.5280309 0.0070930705 0.09547337 -0.06146261 0.07509935 -0.47605544 0.33594677 0.18729596 0.0902348 -0.046042744 -0.3882308 0.21687281 0.269627 0.13636322 -0.33993146 0.13827117 0.5191708 0.28592998 -0.08724131 0.19133943 0.104092434 0.0017289419 -0.005595766 0.39268708 0.31052426 -0.22180438 0.56833225 -0.2906399 -0.3747394 0.5236576 -0.014539123 0.21290924 0.19858818 -0.19209076 0.051275983 0.5200926 0.08390838 -0.19123714 0.03381412 0.0653168 -0.1337945 -0.3220671 -0.5084111 0.059018232 0.25644797 0.20942125 -0.49667975 -0.5104246 -0.39029714 0.37886384 -0.25193745 -0.398692 0.34426063 0.19492812 0.4428096 0.24446845 -0.2375838 0.20550014 0.24564853 -0.31288958 -0.4001296; -0.41184393 0.34621486 0.3087091 -0.22527339 -0.45396045 0.5401274 0.31472394 -0.4553674 0.25673002 0.32789215 0.35886717 0.38842967 -0.3944474 -0.43107232 -0.09663398 -0.32353503 0.35982314 -0.27440795 0.470635 0.26298228 0.13784972 -0.29974917 0.3478044 0.32237828 -0.4887061 0.37353715 -0.14140326 0.5013705 -0.19291537 -0.24264392 0.2197946 -0.35855794 0.13574533 0.17257632 -0.112914264 0.23222153 -0.20273049 0.4283645 -0.109162055 -0.20544228 0.213654 -0.1118192 0.36608467 -0.251827 0.19673409 0.22178298 0.49197924 -0.30705845 0.38795656 -0.35777017 0.43431786 0.41860232 -0.2593998 0.10202913 0.2932905 -0.46674532 -0.4932002 -0.31989527 0.49164933 0.15572083 0.17871405 -0.3261528 -0.26466268 0.42942104 -0.2880247 -0.2483161 -0.19997604 -0.15385172 0.37990287 -0.4354314 -0.3322505 -0.1457105 0.28763732 0.24743314 -0.44580495 0.39005792 0.44565365 0.15839235 -0.3672462 -0.3055899; -0.13496727 0.13278574 0.45907152 -0.45820782 -0.062052496 0.07772805 0.080199726 -0.020083012 0.31309438 0.39719796 0.51213086 -0.20993817 -0.25427854 -0.47222573 -0.54862976 0.051274512 0.25006226 -0.45722908 0.18634745 -0.06332666 0.24177451 -0.5459603 0.39837876 0.25105456 0.12437869 0.043278955 -0.22144887 0.33867395 -0.47013345 -0.32950413 0.06289793 -0.58454245 0.19582416 0.320253 -0.2554098 0.15023622 -0.35968262 0.31436747 -0.3872562 -0.5356 0.56782657 -0.44884858 0.18281391 -0.5047667 0.3946972 0.15809792 0.31188166 0.07308016 0.1323041 -0.51717234 0.04755564 0.49448043 -0.21789588 0.41586125 0.46707833 -0.4747728 -0.29785797 -0.4870872 0.035962295 0.2458589 0.58509755 -0.417057 -0.5625137 0.16407686 -0.38147134 -0.19391571 -0.19465116 -0.29447082 0.30690038 0.040371362 -0.18533613 -0.6029171 0.19665767 0.085058235 -0.39497206 0.3459071 0.021240635 -0.0021217514 -0.4077995 -0.4099777; -0.12607908 0.012659829 -0.18654469 0.5062082 -0.27229583 0.086855665 0.0042474433 -0.24487107 0.097196 -0.5278643 -0.47444844 0.3518775 0.43518692 0.35250157 0.31632763 0.08015427 -0.2685475 0.5375272 -0.025202183 0.12559582 -0.38465998 0.5558522 -0.48174444 -0.23934844 -0.047422066 -0.17032656 0.24117535 -0.41434342 0.41464552 -0.08754926 0.30140007 0.4109031 -0.17045377 -0.36925858 0.288297 0.1457072 0.3746189 -0.29269052 0.33684346 0.4962346 -0.46491712 0.2756523 0.20825385 0.3835006 -0.53701144 0.2595064 -0.65026164 -0.24271625 0.11020069 0.52856827 -0.17156905 -0.20574951 -0.010592537 -0.4979076 -0.105815135 0.5245092 0.2198582 0.4173854 0.16290684 -0.4057479 -0.47725898 0.30545098 0.50392 0.16890141 0.42336568 -0.048906006 0.028026806 0.4363096 -0.2079772 -0.14957657 -0.028688015 0.6573972 0.07073548 -0.12445764 0.25955886 -0.43515754 0.11777899 -0.009531296 0.23854712 0.38199344; 0.10321137 -0.19950272 0.11187677 -0.4529667 0.016823469 -0.26393306 -0.15660562 0.10068875 -0.070942484 0.24899003 0.3337129 -0.09783911 -0.30199954 -0.2603194 -0.5416838 0.10284461 0.55272746 -0.27236232 -0.08790056 -0.09787723 0.37855944 -0.48398125 0.4659242 0.37898207 0.09798572 -0.176287 -0.32313904 0.16121586 -0.4669436 0.10177284 -0.0035564215 -0.30242988 0.35437223 0.24873132 -0.33564168 0.047309276 -0.4736961 0.39638594 -0.5468418 -0.46566245 0.47569284 -0.49860567 -0.12488552 -0.26628324 0.36462322 0.063986525 0.412021 0.2823145 0.010254097 -0.4734094 -0.17545912 0.19545695 0.22756888 0.262761 0.372629 -0.47348902 -0.24678196 -0.4264759 -0.08399559 0.18410213 0.34403816 -0.24204908 -0.5550701 -0.09882203 -0.21144897 -0.19955306 -0.07964891 -0.21382721 0.23318842 0.17425951 0.25996923 -0.4841492 -0.11856143 -0.20706253 -0.32799265 0.30630684 -0.32254702 0.03013132 -0.19443612 -0.19605637; -0.2878005 0.5921161 0.36654454 -0.24300852 -0.29378358 0.41796055 0.31676725 -0.4172891 0.5807434 0.16989416 0.0732861 0.33496338 -0.5287381 -0.048285432 0.03968004 -0.47165817 0.18952642 -0.1244592 0.4621329 0.45226818 0.15090021 -0.18337655 0.33669996 0.44210818 -0.43391696 0.5391148 -0.26972857 0.49531293 -0.25175658 -0.5663781 0.5407554 -0.03597961 0.46627846 0.30235934 -0.17762415 0.32785144 -0.34409967 0.36533993 -0.10552328 -0.28629315 -0.09661307 -0.009513084 0.572605 -0.09262964 0.39842573 0.54683876 0.3674191 -0.57049817 0.21797037 -0.33447033 0.44121572 0.23078299 -0.5516171 -0.17202379 0.46544322 -0.45232254 -0.23282717 -0.12822267 0.3698607 0.018352766 0.2523219 -0.38744175 -0.056868345 0.47457853 -0.14229959 -0.30063877 -0.31237146 -0.5201649 0.30585772 -0.21436028 -0.4224247 -0.2588008 0.58336335 0.54467607 -0.3498716 0.13821305 0.45747685 0.36531335 -0.19615556 -0.38139445; -0.59451926 0.3034887 0.30559894 0.27513033 -0.4916603 0.5399028 0.24543662 -0.2882256 0.41608357 0.24435815 -0.062045787 0.4662096 -0.61433196 0.13320331 0.25557706 -0.522387 -0.14068936 0.26469344 0.24487464 0.26147428 -0.03360768 0.21452859 -0.26048777 0.10490881 -0.26171637 0.27285308 0.16074717 0.3844834 -0.0884122 -0.46168914 0.3996154 0.300582 0.24259393 0.08007478 0.15011069 0.57588273 0.1029114 0.17485064 -0.056097377 0.12589522 -0.01719403 0.22299397 0.33485323 0.052818332 -0.02852651 0.19176628 0.10984537 -0.33014113 0.47561324 -0.0716033 0.61760587 0.222046 -0.55862176 -0.11425016 0.5794562 -0.023397028 -0.4212582 0.19481876 0.22574608 -0.30860746 -0.11387848 -0.37919155 0.22740583 0.25860867 0.14945018 -0.4060772 -0.43236583 -0.53933764 0.5474076 -0.28964266 -0.28241354 -0.07826643 0.46067548 0.4387938 -0.13776527 -0.04059277 0.27127668 0.43422234 -0.38204977 -0.5869824; 0.21330322 -0.41965613 -0.4233702 0.32793495 0.20310369 -0.23249236 -0.2382342 0.22852232 -0.32519147 -0.4990357 -0.40415576 -0.106463075 0.28652102 0.39983553 0.59070295 0.2960838 -0.4712699 0.4721495 -0.2156935 -0.26552203 -0.32582408 0.5034663 -0.21818939 -0.16587703 0.3691847 -0.15243666 0.27975717 -0.33698958 0.26235092 0.4649653 -0.13476193 0.3762005 -0.3025468 -0.32326853 0.35021904 -0.28262538 0.39557883 -0.26766652 0.31657118 0.14159968 -0.32846302 0.15038848 -0.25620592 0.20036356 -0.43833366 -0.22457615 -0.41253844 0.10559493 -0.1918186 0.39337128 -0.4291681 -0.44834808 0.15539241 -0.44017464 -0.2344243 0.3320097 0.450213 0.43580237 -0.18164454 -0.48341477 -0.3722313 0.41079453 0.52631253 -0.3073679 0.33453318 0.48610216 0.21485157 0.44533402 -0.23278448 0.3869718 0.40525436 0.53258944 -0.42886126 -0.34625012 0.4228293 -0.327344 -0.18101053 -0.48882014 0.4114867 0.32326338; 0.34696293 -0.25634453 -0.4347031 0.29016942 0.32193568 -0.3769569 -0.24012631 0.46226072 -0.4006245 -0.46147847 -0.15923566 -0.2391903 0.2043689 -0.19677903 0.015599465 0.37304556 -0.38809654 -0.24595839 -0.25764775 -0.4213441 0.029954674 -0.07598138 0.07175615 -0.46360964 0.2960332 -0.25439274 0.23008625 -0.482166 0.20399508 0.5038037 -0.2442481 -0.16560288 -0.29363486 0.02203133 -0.12582281 -0.3002768 0.15144101 -0.31476757 0.14378768 0.08105021 -0.07942976 0.082877725 -0.42792633 0.12327157 -0.17513235 -0.32590884 -0.09566506 0.5447193 -0.26450565 0.17287438 -0.24633919 -0.4034768 0.5956667 0.28760922 -0.4925938 0.15706983 0.5623741 0.14712998 -0.2399536 0.030611308 -0.095937245 0.36089367 -0.2525473 -0.32658023 -0.11942739 0.40563077 0.46204737 0.43259424 -0.38082707 0.38065016 0.60654384 0.22576529 -0.5368387 -0.55931836 0.33267576 -0.3020378 -0.51658124 -0.47037274 0.18458998 0.17304733; 0.5515986 -0.50723964 -0.4049083 0.23478541 0.61169934 -0.50424206 -0.43549243 0.2169552 -0.22526763 -0.14135614 -0.10350794 -0.2762499 0.13572311 -0.023335993 -0.17055558 0.34326074 -0.13471168 -0.18338186 -0.27792206 -0.43522188 -0.15878358 0.2762056 -0.14177778 -0.43835202 0.5364715 -0.30783838 0.3613974 -0.40394223 0.41691458 0.3223205 -0.5311402 0.04270621 -0.44810504 -0.34689003 0.20326367 -0.5696085 0.4417164 -0.20677015 -0.006668717 0.20301896 0.06268743 0.3077387 -0.5266872 0.28713638 0.0013235069 -0.45499644 -0.116414815 0.5312496 -0.5957578 0.17131504 -0.3403958 -0.4451775 0.2926855 -0.02727017 -0.37784767 0.31673914 0.5187302 0.0854474 -0.38300294 0.17613427 0.047114987 0.21771416 0.082094304 -0.5195389 -0.052620165 0.4024465 0.54832166 0.23921488 -0.42871022 0.45948547 0.3640953 0.21128559 -0.48832425 -0.29382274 0.15103064 -0.093054004 -0.38758695 -0.4410819 0.47006077 0.23115332; 0.36703536 -0.43548605 -0.40731078 -0.099745594 0.56557715 -0.4378515 -0.54069644 0.19501673 -0.25488138 -0.25291193 0.08310519 -0.45691258 0.3423872 -0.17953195 -0.29645428 0.377418 -0.049150232 -0.23953488 -0.4541564 -0.4573831 -0.043205116 0.047416694 0.07779513 -0.10873808 0.38808647 -0.48960146 0.2152488 -0.4734517 0.3144818 0.42353272 -0.56731844 0.009169293 -0.46464613 0.010224695 -0.22592872 -0.41574502 0.25674087 -0.36389452 -0.06723494 -0.059306774 0.031796105 -0.013846862 -0.5424922 0.100697115 0.11755657 -0.4790462 -0.100246005 0.32120368 -0.5367705 -0.11632567 -0.41984785 -0.41129398 0.36456648 0.111680284 -0.34683508 0.32280976 0.2578078 -0.17021625 -0.35873014 -0.040098608 0.041685104 0.35904005 -0.25732523 -0.3330529 -0.08787949 0.41659394 0.29098082 0.44775352 -0.5259348 0.5963745 0.44849044 -0.03366088 -0.28308296 -0.42221484 0.35641682 -0.09637146 -0.39209795 -0.3588076 0.3054085 0.26393595; 0.22067188 -0.47925165 -0.3017884 0.1889039 0.33276504 -0.30141908 -0.31322613 0.3113794 -0.53187 -0.15942271 -0.22626361 -0.5229691 0.21411116 0.37826753 -0.21536145 0.37276492 -0.32861012 0.13544154 -0.24635431 -0.31304294 -0.1802275 0.45960176 -0.23659104 -0.33024448 0.5404205 -0.32431528 0.19328766 -0.15881753 0.20888111 0.2972548 -0.4815575 -0.005950142 -0.46890366 -0.10201427 0.39092746 -0.34535423 0.47641414 -0.34504926 0.34710503 0.4029333 -0.17971183 0.1883476 -0.40512386 0.12976395 -0.35986373 -0.20190963 -0.13015853 0.5296113 -0.42550546 0.24216229 -0.4468462 -0.1568217 0.31223866 -0.12875056 -0.17584255 0.35695767 0.25268182 0.124403395 -0.5150252 -0.35840335 -0.3526777 0.19582734 0.13230844 -0.23559694 0.11510568 0.1622064 0.46819273 0.38211778 -0.16896595 0.4815273 0.38838667 0.4915736 -0.41477188 -0.29813305 0.1314307 -0.25055 -0.23354365 -0.2630655 0.19850047 0.3122541; -0.53258264 0.3949147 0.52069473 -0.32251465 -0.3688678 0.42207754 0.4893436 -0.33238676 0.5198108 0.25897628 0.44124103 0.29479408 -0.3806266 -0.2688559 0.011766591 -0.3741268 0.20321564 -0.2840653 0.21460055 0.48492935 0.024294255 -0.20370524 0.10071246 0.4223561 -0.5311782 0.22491208 -0.32765087 0.13452718 -0.28814235 -0.22551262 0.36337236 0.119786255 0.39741737 0.101052575 -0.09794171 0.32264307 -0.30431312 0.28202757 -0.32897758 -0.3896216 0.25467008 -0.100778624 0.4496003 -0.13509895 0.19370449 0.44067603 0.34640732 -0.33172017 0.41414586 -0.10753205 0.3703601 0.3119639 -0.52698994 -0.03670633 0.48869237 -0.2600193 -0.476176 -0.43369868 0.31998911 0.17012724 0.066216215 -0.13729578 -0.14602035 0.2300947 -0.13211745 -0.49747086 -0.1793574 -0.17887777 0.38266692 -0.5675577 -0.37185434 -0.42047864 0.5711486 0.341544 -0.45752332 0.12673253 0.38315588 0.19537066 -0.34061748 -0.24186411; 0.6073785 -0.329006 -0.5038116 0.11256414 0.5920663 -0.34983286 -0.37781206 0.28377947 -0.5464393 -0.08023594 -0.14047955 -0.32925037 0.35152778 -0.13872874 -0.34231573 0.5307804 -0.18857935 -0.18168859 -0.40709218 -0.4520722 0.08129253 0.1858754 -0.10561537 -0.28260335 0.32830098 -0.3652238 -0.053251695 -0.50393474 0.18113579 0.30293316 -0.30155003 -0.20116156 -0.10385274 -0.13210195 -0.23585561 -0.42659634 -0.037210613 -0.46512076 -0.061976213 0.11108133 0.1942994 -0.13596669 -0.3051977 -0.12815528 0.025326343 -0.49229315 -0.19509009 0.37384257 -0.3254974 0.21755815 -0.4315084 -0.47490978 0.30560848 0.24785389 -0.30098626 0.10816304 0.47430566 0.0011682004 -0.18257703 0.103491366 0.17675237 0.4731077 -0.27366024 -0.40301755 0.053684544 0.47102198 0.62036127 0.19431755 -0.42553163 0.28698662 0.6154453 0.07764561 -0.52089226 -0.23563701 0.073575705 -0.21984018 -0.3325377 -0.6259614 0.43643704 0.40189183; -0.08222229 0.116625704 0.118193045 0.40248495 -0.09391766 0.012775709 0.29591626 -0.042028606 -0.013939387 -0.25512367 -0.42117324 0.19436857 -0.09102478 0.22619852 0.29391316 -0.1138636 -0.34219632 0.45300856 0.34471884 -0.02040073 -0.3195899 0.42122212 -0.32334775 -0.5628121 -0.2591061 0.00078739173 0.23414676 -0.43903786 0.25604555 -0.22500215 0.24803056 0.2322193 -0.25059044 -0.30806708 0.5209949 0.25958937 0.30119044 -0.47756794 0.52930766 0.5189365 -0.5431584 0.16729897 0.047899462 0.27337053 -0.354014 0.3026582 -0.39036572 0.028290655 0.3166117 0.46259195 0.1368268 -0.19446085 -0.093111485 -0.38254043 0.061738 0.32902405 -0.18603614 0.27219963 0.15914541 -0.19180146 -0.34517363 -0.028155496 0.18758732 -0.038619142 0.30171528 -0.12974103 -0.194478 0.46755624 0.04801567 -0.06555586 0.00801593 0.5376811 -0.06708924 0.080974065 0.4115781 -0.40953535 0.18909426 0.085423015 0.10701839 -0.08785996; 0.052392613 -0.008043697 -0.23367244 0.52609485 -0.06789738 0.19371967 0.052495915 -0.14864203 -0.025425646 -0.22426046 -0.6089197 0.028915675 0.21629182 0.39034733 0.4127101 0.0415046 -0.49174076 0.4448396 0.27295443 0.09856522 -0.26024413 0.5351808 -0.2697429 -0.52689844 0.08535219 -0.04641027 0.35802308 -0.21780221 0.5419216 0.080156945 0.071451895 0.18238586 -0.55431646 -0.61351573 0.32924366 0.11355746 0.5921391 -0.35782003 0.2363403 0.3799625 -0.345857 0.32831386 0.09311012 0.5433586 -0.27260944 -0.0021257498 -0.42193434 -0.30594042 0.22608168 0.37442607 0.08079704 -0.33445072 0.08549984 -0.3066993 -0.35022143 0.47653607 0.16678245 0.36133215 0.082911715 -0.4751588 -0.29672813 0.18251124 0.4234121 0.15465058 0.22785096 0.02373997 -0.060027055 0.15611139 -0.25508308 -0.11378081 0.0928846 0.49010107 -0.13074075 0.08803968 0.5340631 -0.4622561 0.19984156 -0.1852387 0.29850137 0.08575948; -0.4790932 0.57319146 0.44819227 -0.29828835 -0.3370435 0.44656113 0.30182847 -0.29971644 0.4693279 0.4756922 -0.08672733 0.46709543 -0.31737852 -0.102477595 0.29208145 -0.2269983 0.12683819 0.2046069 0.42294738 0.58413076 -0.17554492 -0.23730758 -0.041971758 0.09736032 -0.5666409 0.5285015 -0.025734283 0.23427112 -0.19920678 -0.6025516 0.30985186 0.27459943 0.36983258 0.26500404 -0.10743656 0.31089708 -0.15409751 0.13245456 0.028840516 -0.032806657 0.079527065 -0.0628616 0.45295137 -0.06061279 0.13506788 0.55075437 0.3035989 -0.5944653 0.2809963 -0.20514873 0.46823192 0.12565696 -0.34142494 0.06965173 0.36815554 -0.14987177 -0.46795547 -0.20974281 0.4942467 -0.24323879 0.17787914 -0.16816257 0.23740593 0.46768945 0.037552506 -0.41364604 -0.61069155 -0.4132952 0.3508717 -0.59752774 -0.5970374 -0.29667357 0.5207122 0.3967813 -0.33940643 0.17594922 0.24784909 0.33532435 -0.19436228 -0.26125753; 0.013529677 -0.20455575 0.34840572 -0.41365987 0.09863907 -0.27270266 0.15736067 0.015211007 -0.20688535 0.55152124 0.28008088 -0.14481431 -0.26887602 -0.4845323 -0.34341013 0.18274103 0.27378574 -0.3507771 -0.10098742 -0.27419952 0.50958675 -0.23397417 0.3880905 0.6031393 0.0040169302 0.13508508 -0.31393132 0.3143575 -0.5461172 0.19852354 -0.055073522 -0.49342614 0.37542513 0.5035442 -0.46409953 -0.0069772215 -0.34719363 0.35019812 -0.43347335 -0.38194886 0.28939536 -0.5999892 0.060329895 -0.49759138 0.49541873 -0.22870882 0.508922 0.022406908 0.13775113 -0.23222986 0.10561511 0.38263336 0.15013696 0.37521276 0.29989642 -0.24697246 0.014860155 -0.5591359 -0.28096682 0.55857044 0.44476435 -0.08819005 -0.30185807 0.06734548 -0.32624918 -0.07358951 -0.12238593 -0.5033848 -0.015778521 0.20301907 0.28688565 -0.44101653 -0.25898904 0.06383851 -0.56215924 0.57790685 0.025313107 0.068869136 -0.35348865 -0.100131266; 0.27423447 0.03899957 -0.13064678 0.45564842 0.15518159 0.17671797 -0.017018761 -0.08893751 -0.1413497 -0.24308237 -0.4775669 0.21196905 0.19405206 0.3302265 0.20373774 -0.22770265 -0.35560465 0.47741592 0.028829657 0.03839357 -0.525323 0.44381705 -0.56860614 -0.46349815 -0.027948983 -0.28841814 0.5628425 -0.5262175 0.34183076 0.049039096 0.17412941 0.2677383 -0.35281634 -0.3879441 0.34568137 0.05657618 0.5211403 -0.297951 0.20060408 0.2817373 -0.51928735 0.27081507 -0.1308846 0.5290449 -0.38220212 -0.03528426 -0.36500508 -0.15284565 -0.16375147 0.32605115 -0.017637562 -0.39587435 -0.10971964 -0.24863924 -0.26326424 0.54913336 0.3933879 0.28535798 0.02716777 -0.22696266 -0.27233547 0.19174902 0.44493186 -0.17398341 0.4156372 0.16206326 -0.075116694 0.34807706 -0.10754211 -0.15128402 0.15220007 0.4830348 -0.067510694 0.005975493 0.43498453 -0.29773438 0.014234797 0.050221954 0.11857143 0.18125725; -0.36504427 0.4545458 0.5518705 -0.13534564 -0.58333725 0.39085174 0.5472467 -0.2750371 0.5168691 0.1181142 -0.123183444 0.3348066 -0.36651528 0.14062673 0.058000363 -0.4562404 0.05585155 0.32221583 0.4939048 0.27844775 -0.15812828 0.18913041 -0.040158056 0.18188713 -0.23925224 0.30326837 -0.002887671 0.47590646 -0.057292122 -0.46027222 0.4640686 0.27073675 0.18990229 -0.113283195 0.14782909 0.50864255 0.049016096 0.17326243 0.28169706 0.029610148 -0.28770557 0.12216436 0.5239255 -0.09101974 0.08958192 0.43471718 0.04505762 -0.3476536 0.34880307 0.08574607 0.5739984 0.37359145 -0.56110835 -0.30286166 0.36099744 0.03146195 -0.32033524 -0.0072354395 0.25684008 0.06501771 -0.22798663 -0.5524381 0.040142763 0.3245654 0.2503992 -0.46669573 -0.33658162 -0.17923798 0.43431404 -0.39247662 -0.35218936 -0.058903772 0.43361837 0.53135335 0.031920485 0.017763715 0.19531193 0.55386066 -0.5477707 -0.26055387; 0.24687643 -0.5089265 -0.37129402 0.3802652 0.3167415 -0.44019216 -0.26272637 0.01551845 -0.30914804 -0.34613985 -0.3953883 -0.23051049 0.4445898 0.2183185 0.48168933 0.44368243 -0.4374927 0.51471424 -0.44652504 -0.4745525 -0.47161782 0.3845056 -0.52328336 -0.29838377 0.39036363 -0.13114448 0.4192444 -0.14880419 0.40385154 0.32608995 -0.09756709 0.35528055 -0.17753893 -0.28197917 0.477313 -0.32610974 0.4334867 -0.21210355 0.30785894 0.4397657 -0.25839263 0.28052288 -0.48748738 0.4961313 -0.23241302 -0.40138924 -0.39881295 0.42827594 -0.346099 0.48442045 -0.18204364 -0.22987315 0.37140453 -0.5845958 -0.30537167 0.23832308 0.51706105 0.40363774 0.06688718 -0.34274304 -0.26428115 0.35464385 0.5892182 -0.45360184 0.39420956 0.20653927 0.48369598 0.22477514 -0.5306397 0.3739327 0.31523332 0.37747446 -0.3897006 -0.37126485 0.432168 -0.24236843 0.16279803 -0.20753852 0.14858678 0.1914437; 0.045348316 -0.04246379 -0.33830374 0.35961723 -0.1263526 -0.05548733 -0.19746105 -0.0068193264 -0.14960231 -0.20299603 -0.3045812 -0.045298897 0.15402976 0.38390437 0.5195243 -0.08732305 -0.3571225 0.33224517 0.078377806 0.14437836 -0.31409866 0.26152536 -0.32714263 -0.28941616 0.046782173 -0.1878167 0.5947515 -0.15784547 0.38069597 0.09407093 -0.057146315 0.37068588 -0.44648725 -0.616124 0.4964853 -0.0030068508 0.23459576 -0.50202626 0.59238744 0.30278182 -0.30444226 0.58094656 -0.18937737 0.56263834 -0.39482957 0.034633096 -0.34491432 -0.14237991 -0.20112252 0.6008843 -0.039869707 -0.22148475 -0.016074004 -0.37427512 -0.4144486 0.31589898 0.24398218 0.4946802 0.10321103 -0.30971396 -0.26204404 0.322153 0.24310607 -0.20922486 0.30055276 0.1250176 -0.023636168 0.4351447 -0.22316806 0.22451015 -0.1382331 0.5036426 -0.25739947 -0.16505484 0.37411854 -0.5667945 0.1204187 0.04046176 0.466106 0.25423726; 0.05921252 -0.18229152 -0.16794461 0.39122558 0.110653706 -0.055281937 -0.006755614 0.07453128 -0.27587724 -0.2422772 -0.543594 0.09140228 0.29308262 0.38829654 0.52490973 -0.09547372 -0.52405506 0.3165919 0.0034371598 -0.0719022 -0.45980823 0.40377563 -0.39575368 -0.5362173 -0.06324508 -0.039627142 0.49087673 -0.2802673 0.4058895 0.0051713255 -0.05404789 0.5315915 -0.28845376 -0.6192636 0.34828344 -0.30175686 0.40928143 -0.17153925 0.38458768 0.29364163 -0.51567334 0.45075548 -0.21897352 0.55441535 -0.5691979 0.08553015 -0.23196667 -0.036532264 -0.024937835 0.47044313 -0.18868938 -0.2390665 0.108489625 -0.23230638 -0.24193627 0.3943566 0.45108357 0.28847173 0.31036255 -0.2245261 -0.43160346 0.32534742 0.5014687 -0.29542044 0.5465439 0.34837243 0.07198434 0.2425448 -0.1366876 0.040791493 0.07764376 0.37685323 -0.17289357 -0.24679965 0.3238577 -0.30073845 0.0221256 -0.26471734 0.1506 0.19508895; -0.2842973 0.34726042 0.48939353 0.15213089 -0.49390435 0.34749854 0.4838163 -0.20517576 0.62767905 0.24643573 0.0356714 0.46856692 -0.22940789 0.08993464 -0.01938249 -0.5560468 -0.026601495 0.07741762 0.48107922 0.37193108 0.08899052 -0.09895794 -0.16026488 0.2577765 -0.3185106 0.54070747 -0.0499213 0.16907276 0.05532773 -0.49803197 0.28930312 0.28727797 0.17332494 0.19016293 0.26639006 0.45952782 -0.19500841 0.2391166 0.17216495 0.24158819 -0.23395173 0.105482206 0.6042819 0.26712358 -0.12229283 0.27697563 0.26170456 -0.33219805 0.5082117 -0.05080721 0.605328 0.18628599 -0.33032465 -0.01267364 0.27922916 -0.25649288 -0.6324739 -0.10109721 0.54507846 0.05795124 -0.28754404 -0.21374308 0.1820842 0.31268132 0.14317249 -0.4234725 -0.5268711 -0.4641225 0.54429615 -0.39982942 -0.2647228 0.078278214 0.2701868 0.62220883 0.014869945 0.18863913 0.3050886 0.3776575 -0.4030844 -0.52836794; -0.16501626 -0.13781033 0.1535547 -0.30498973 0.19326632 -0.00078725175 0.09746505 0.20537357 0.23656638 0.41904593 0.51343757 -0.045005437 -0.32928625 -0.3714376 -0.23978338 0.1647807 0.3105883 -0.5351741 0.11951786 -0.23151945 0.3269707 -0.44354063 0.478265 0.29955488 -0.1112536 0.015606119 -0.35471556 0.28825855 -0.38915128 0.08964844 -0.15386915 -0.23134391 0.2502576 0.4486653 -0.56359726 0.029574284 -0.42318687 0.28734168 -0.60000753 -0.5999141 0.56756914 -0.343915 0.06041815 -0.4314609 0.3882251 0.057566162 0.5447532 -0.07623673 -0.117389835 -0.60452384 0.3531982 0.1341518 -0.18353164 0.5080661 0.32640654 -0.5404657 -0.25363418 -0.5659441 -0.22957684 0.33820888 0.32609382 -0.257636 -0.5118262 0.14064391 -0.34352094 -0.0783521 -0.30880034 -0.32531768 0.21220759 -0.060559012 -0.17791727 -0.54011774 -0.12557185 0.049194854 -0.26238275 0.4997869 0.0037478507 -0.011759018 -0.090436995 -0.32653886; 0.24313726 -0.1670584 -0.16706851 -0.48506826 0.18138501 0.025405651 -0.19418728 0.049694158 -0.20045075 0.3545231 0.3458363 -0.25443575 0.11112708 -0.29460615 -0.1197381 0.35408205 0.23295528 -0.24902555 -0.0591376 -0.011989698 0.47330552 -0.424448 0.2635115 0.24630566 0.2677166 -0.30308285 -0.32905814 0.45464534 -0.49957126 0.15395358 -0.28493872 -0.4875009 0.2969334 0.1974512 -0.3639533 -0.025348522 -0.3831231 0.34949586 -0.4097788 -0.35061324 0.15199819 -0.4334386 -0.30347496 -0.30422217 0.5439025 0.054523945 0.47294652 0.34068516 -0.0054347515 -0.21408886 -0.051839277 0.36986727 0.032663856 0.25140712 0.042043578 -0.3101799 -0.023796253 -0.36578712 -0.035864383 0.41755402 0.27907977 0.06526867 -0.49688834 -0.17462316 -0.4970737 -0.01802693 0.097251296 -0.3611964 -0.25641823 0.2675309 0.24998066 -0.48685586 -0.0657526 -0.2077105 -0.27704605 0.47363755 -0.036388744 -0.281185 0.09857134 0.17967705; 0.60527974 -0.5382147 -0.5477616 -0.15135615 0.31592786 -0.48082432 -0.5069155 0.22490485 -0.63668865 -0.04667737 -0.09137893 -0.51427734 0.5139433 -0.026929503 -0.16679348 0.39628047 0.15405683 -0.1870533 -0.47792852 -0.56336784 0.09512875 -0.044023227 0.19750099 -0.2683165 0.19362967 -0.24794891 -0.008991804 -0.13976213 -0.041376144 0.4268193 -0.18952683 -0.017119346 -0.2733163 -0.034163516 -0.0107150385 -0.49640965 0.13609628 -0.33749646 -0.17806067 -0.2166998 0.04256346 -0.097233385 -0.4436136 -0.17642641 0.23691286 -0.46445903 -0.08750937 0.29019868 -0.57345164 -0.1621984 -0.27639166 -0.10074058 0.51650655 0.09094386 -0.5871286 0.04773196 0.6378099 -0.12708637 -0.18337342 0.15566179 0.22776917 0.21611343 0.07900021 -0.5888454 -0.21113831 0.5819404 0.30956614 0.44721502 -0.4120871 0.4667697 0.34249398 0.11257486 -0.43742266 -0.54874694 -0.034083486 -0.025437841 -0.46409768 -0.24943557 0.29830354 0.27422258; 0.5143095 -0.44708765 -0.23599121 0.08580526 0.26916265 -0.58669835 -0.51043963 0.2127105 -0.5342988 -0.22047456 -0.17379981 -0.35373864 0.19147602 0.21494775 -0.29653642 0.46715492 -0.08979845 0.11569132 -0.25707167 -0.54557794 -0.16730651 0.14479382 -0.26511425 -0.12587465 0.48057032 -0.25438267 0.18254338 -0.18317561 0.4120425 0.48912483 -0.37954652 -0.11552619 -0.21358985 -0.34182286 0.16854148 -0.53019094 0.13882776 -0.26903024 -0.061425447 0.08406287 -0.010698653 0.005293214 -0.38532665 0.11044025 -0.37516972 -0.38292983 -0.29334673 0.32445067 -0.22002126 0.14115554 -0.33057758 -0.19182901 0.27054268 -0.14467233 -0.39936 0.18748736 0.3570982 0.26709926 -0.23467173 0.0052944724 -0.20047699 0.2015907 -0.162275 -0.23652406 0.06617456 0.3741056 0.31983998 0.31979495 -0.24661502 0.3220726 0.49691153 0.3068332 -0.3282336 -0.3394529 0.0883796 -0.20099305 -0.039535116 -0.4157371 0.17039838 0.29550123; -0.5157822 0.47562644 0.25261313 -0.059967235 -0.44406348 0.217584 0.2719686 -0.19029692 0.37865445 0.12959415 -0.11439671 0.38981292 -0.2554708 -0.04466239 -4.1746323f-5 -0.19397505 -0.019520493 0.04905064 0.427935 0.23365207 -0.31427622 0.14818522 -0.20462094 0.0507239 -0.48476848 0.46593627 0.23222494 0.0934364 -0.070828825 -0.4647698 0.18192933 0.2180901 -0.1504827 -0.20406996 0.19219078 0.5192216 0.20812196 0.33661765 -0.059418753 0.10589604 -0.28741986 0.014157185 0.437652 0.13012037 -0.101725586 0.48656377 0.095564045 -0.33161783 0.33327055 -0.05615654 0.34609285 0.20565215 -0.44062403 -0.26291013 0.60184366 0.23511001 -0.5408098 0.26973343 0.2959505 -0.07486828 -0.23027456 -0.51001775 0.2992533 0.26687104 0.20339839 -0.40277252 -0.52824414 -0.46381855 0.32047114 -0.40557295 -0.36259493 0.031821024 0.48575994 0.5594352 0.2130522 -0.14637883 -0.043368503 0.3167626 -0.31099185 -0.48077807; 0.43096253 -0.11395938 -0.28463298 -0.051937737 0.1192829 -0.12746274 -0.51852006 0.076489344 -0.5216325 0.08722334 0.16874214 -0.20996495 -0.19816974 -0.2821557 -0.27874058 0.24299745 0.037933398 -0.32097542 -0.15042047 -0.021382894 0.1252952 -0.18355599 0.11056349 0.06382273 0.18342076 -0.35831967 -0.026944492 -0.20165364 -0.2451247 0.20954752 -0.298259 -0.31078324 0.05725508 0.07770389 -0.27646896 -0.34999785 -0.08955265 -0.20675677 0.039728202 -0.2306423 0.075723894 -0.22742 -0.18677832 -0.16606887 -0.03950608 -0.055704143 0.19991447 0.011714038 -0.16905361 -0.054724187 -0.41245925 -0.44872206 0.027032726 -0.013483031 -0.46761593 -0.18505502 0.3496773 -0.27834082 -0.11217938 0.27639788 0.2023741 0.19684723 -0.27860758 -0.4847065 -0.17748743 0.36223957 0.26342162 -0.08544958 -0.19189787 0.06569399 0.32020548 -0.26897645 -0.014492394 -0.36262172 -0.10593554 0.31013316 -0.22043452 -0.42903915 0.22418332 0.48028815; 0.35707816 -0.1752242 -0.15450002 0.4800736 0.008383966 0.21839046 -0.07016682 -0.2998785 -0.17191033 -0.44712836 -0.26450694 0.27401066 0.3583958 0.44924074 0.5351072 -0.23957196 -0.36531195 0.57988626 0.019596014 0.07758654 -0.60916436 0.45507875 -0.46124277 -0.30468574 -0.17025486 -0.32411388 0.520175 -0.46884963 0.4837586 0.24640518 0.0070022778 0.4917646 -0.3177259 -0.51491964 0.57854396 -0.24092257 0.2790877 -0.26233336 0.29296935 0.33588704 -0.5964797 0.58578306 -0.1799591 0.3738124 -0.39727098 -0.14413334 -0.56613576 -0.0673749 -0.056707777 0.5614493 -0.21313582 -0.419069 0.069576606 -0.52294254 -0.43660644 0.2370218 0.18024215 0.379497 0.27388996 -0.3935401 -0.40982363 0.45788604 0.29344735 -0.09838177 0.39252937 0.21023858 0.023390803 0.28051648 -0.11633313 0.0425609 -0.047222953 0.46251464 -0.3166996 -0.10330511 0.37068582 -0.33093432 0.24141711 -0.103244714 0.49412727 0.22126451; 0.29948777 -0.59938467 -0.19346496 0.08354621 0.5351576 -0.2937236 -0.29327342 0.24099982 -0.57754207 -0.12086822 0.0061364574 -0.27329475 0.4998954 -0.104521886 -0.061192118 0.26478067 0.052387103 -0.30620423 -0.37322253 -0.29184383 0.22264375 0.037517387 0.23626858 -0.033892453 0.25171384 -0.29891634 0.03803598 -0.33638635 0.009930152 0.24522653 -0.3891122 -0.057693023 -0.15310831 -0.03783908 0.029226778 -0.5520732 0.21046129 -0.20564787 -0.026229355 0.020289714 0.11640051 -0.14057037 -0.22492805 -0.08447379 0.18739206 -0.58068687 0.010589049 0.24801007 -0.29090464 0.16188437 -0.40172908 -0.46356684 0.31771114 -0.027523473 -0.35256454 0.14682706 0.42630437 0.10757392 -0.49783948 0.04007565 0.24181636 0.21578033 -0.112336844 -0.26707736 -0.18880028 0.44515935 0.38751993 0.37897095 -0.58613133 0.24595632 0.41921797 -0.023467725 -0.5052757 -0.29195535 0.08902105 -0.10513619 0.031870265 -0.4937513 0.4537433 0.37785947; 0.4886927 -0.3168248 -0.40402165 0.22381464 0.27440554 -0.29220006 -0.22763778 0.5254266 -0.24013388 -0.4178505 -0.30689996 -0.30015016 0.48184362 0.15325841 0.022608923 0.5938072 -0.2177177 0.3622307 -0.1876926 -0.3651609 -0.286155 0.29587153 -0.4259211 -0.11874014 0.5214566 -0.3794515 0.39754727 -0.22899204 0.29057294 0.28090984 -0.3828272 0.28726402 -0.19756617 -0.38380533 0.06930656 -0.15914574 0.48717633 -0.15388532 0.2561502 0.18118598 -0.089212574 0.4278449 -0.2313631 0.075083725 -0.3806333 -0.40470582 -0.31638336 0.23181887 -0.25781223 0.46168113 -0.3450918 -0.33613327 0.5374361 -0.062114794 -0.13867663 0.39169306 0.46534127 0.12819114 -0.23012403 -0.17564571 -0.32784382 0.42458072 0.12444184 -0.34473068 0.13249987 0.3967444 0.513535 0.26532733 -0.26816446 0.27006167 0.34130546 0.28913757 -0.52518123 -0.47692922 0.3407381 -0.33562323 -0.23095079 -0.41744873 0.45427856 0.27047896; 0.4853366 -0.21190089 -0.47181407 -0.22194389 0.5842029 -0.3840849 -0.49043727 0.19774354 -0.26327524 -0.17078751 0.24922 -0.36394146 0.31939968 -0.23454566 -0.2634245 0.41919836 -0.033181492 -0.036230482 -0.6121245 -0.26074824 0.009083875 -0.039279606 0.14780298 -0.13524796 0.2759712 -0.4879834 0.14667203 -0.34424093 0.21077187 0.20571855 -0.2993107 -0.20360616 -0.3171262 0.19379655 0.017223498 -0.61501855 0.06673522 -0.42925107 -0.2852197 -0.1416915 0.21180253 -0.17049478 -0.36163363 0.095006905 0.18018961 -0.2661793 0.17097627 0.36334485 -0.4855506 0.05141142 -0.44565615 -0.5102711 0.39820334 0.27633044 -0.5262933 0.08489882 0.4503574 -0.03530176 -0.408008 0.15287983 0.07797102 0.61854297 -0.29093388 -0.28514275 0.09831383 0.35016492 0.6101811 0.4251933 -0.31259075 0.47756848 0.4694954 0.124657854 -0.5537545 -0.583414 -0.089684695 0.14236376 -0.32330778 -0.39733714 0.31638077 0.5244724; 0.37987325 -0.08324456 -0.437915 0.5386416 0.09742906 0.03945788 -0.2870229 -0.30333135 -0.39635655 -0.31344327 -0.36518273 0.012636219 0.16996495 0.58311963 0.2529495 0.1114856 -0.40887812 0.33702722 -0.089139536 0.07805059 -0.31987682 0.34926045 -0.45521978 -0.43838423 0.060859937 -0.21163268 0.53595096 -0.4174233 0.27916697 0.13057297 0.08974543 0.26583967 -0.21656586 -0.38114923 0.5901744 -0.29233584 0.46408188 -0.14692326 0.55434775 0.44310766 -0.58494985 0.27844042 -0.37420782 0.47351322 -0.4130197 -0.36303422 -0.42628536 0.13028905 -0.12843095 0.4481635 -0.40899903 -0.21769886 0.38086626 -0.30692816 -0.45380473 0.31033623 0.110245444 0.35005695 -0.002095376 -0.3084052 -0.5307636 0.30696815 0.3056078 -0.18430874 0.43102103 0.35776773 0.31964475 0.32509223 -0.17935467 0.34400898 -0.0050188117 0.49525377 -0.22327271 -0.38449395 0.39990252 -0.4863963 0.17864616 -0.35288033 0.27524334 0.47364765; -0.12113272 0.087464936 0.09845282 -0.35562116 -0.09628462 -0.05775846 0.14550902 0.29392287 0.30291742 0.30069515 0.40314144 -0.32191682 -0.33543488 -0.6050495 -0.30136177 0.24999118 0.5646623 -0.4712498 -0.16562216 -0.16875117 0.43641192 -0.36369526 0.4345685 0.20625037 -0.051874254 0.3604592 -0.31317213 0.17501327 -0.4760809 -0.2935417 -0.16536334 -0.44656107 0.25704497 0.6509287 -0.297688 -0.049683057 -0.53065914 0.18268465 -0.5930014 -0.27349362 0.60541517 -0.47560588 -0.064323425 -0.27966818 0.4589498 -0.084553294 0.40886676 0.16468737 0.078252696 -0.5611925 0.3737917 0.30414355 -0.058081105 0.23413251 0.09693054 -0.35943678 -0.17372891 -0.29482293 0.025647752 0.4570212 0.26838478 -0.38928133 -0.45051348 0.15888688 -0.46561497 -0.19908617 -0.32008055 -0.44621462 0.099431224 0.031315397 -0.21569103 -0.54450744 -0.018985374 0.07933734 -0.3214052 0.25095898 -0.329702 0.33461657 -0.1399102 -0.1973914; -0.3794403 0.5384641 0.22704789 0.058350485 -0.53186697 0.29747877 0.37987232 -0.5611176 0.4995028 0.19228958 -0.20745258 0.48523542 -0.49051693 0.1694329 -0.020699559 -0.3601834 0.39085463 0.13701993 0.49410877 0.5617921 -0.18412708 0.17076083 0.16963308 0.41176713 -0.23863421 0.42781958 -0.36474103 0.13862684 -0.008759413 -0.37393636 0.35310358 -0.018666262 0.23576578 0.046290874 0.0057473117 0.36907026 -0.30793402 0.49433202 0.2893372 0.05673491 0.077699974 0.026515853 0.37453094 0.10514492 0.15692955 0.32539588 -0.077446535 -0.41741562 0.4168734 -0.13339731 0.20968263 0.23991416 -0.37503257 -0.17723656 0.3470496 0.0027297998 -0.5561967 -0.2845515 0.31621078 -0.17784533 0.14815833 -0.5345322 -0.022471046 0.45069605 0.113653265 -0.55978143 -0.57790637 -0.3171054 0.42796904 -0.38111582 -0.5110296 -0.17593671 0.52862537 0.5019297 -0.16420212 0.075079046 0.42958432 0.37788677 -0.4195373 -0.4470584; 0.32991636 -0.17902021 0.14944196 -0.5515975 0.21602072 -0.20446265 -0.18133429 0.12851152 0.07327268 0.24620308 0.22252983 -0.03331083 0.07019348 -0.4438498 -0.06688685 0.1669139 0.37302002 -0.32858983 -0.11332858 -0.1599325 0.42551154 -0.5237759 0.5434924 0.24244148 0.07441299 -0.21378888 -0.30537182 0.5677379 -0.41428342 0.14760432 -0.17868288 -0.41386715 0.3398552 0.5051603 -0.40830952 -0.22882071 -0.18337128 0.5627122 -0.24773876 -0.25995916 0.3156859 -0.3623044 -0.08326527 -0.19706783 0.20035218 -0.213678 0.49082294 0.1342324 -0.068182364 -0.3024712 -0.1608826 -0.07909182 0.13072468 0.26110548 -0.1049485 -0.3659341 0.21066087 -0.40602073 -0.11887435 0.24530473 0.22021924 0.15747233 -0.29424882 -0.15146674 -0.17925201 -0.025042769 0.08652806 -0.4143531 0.104361586 0.16809815 0.19854984 -0.21599098 -0.074825004 -0.21369468 -0.35396656 0.43370298 -0.06417258 -0.0617736 0.12075671 -0.05932914; -0.6332792 0.37058252 0.38917008 -0.043488774 -0.3919867 0.37282214 0.3578738 -0.31801146 0.36030906 0.33378989 -0.05675694 0.420745 -0.3679995 0.1373885 0.25043228 -0.39740235 0.21813883 0.13116057 0.4576055 0.24600244 -0.033515982 0.12890549 -0.019496597 0.064372666 -0.35192335 0.298537 -0.20533112 0.33251762 -0.13385628 -0.42004308 0.5471247 0.22651967 0.4587519 -0.18293035 0.034075227 0.27458718 -0.04828321 0.25533688 0.09373825 -0.12588818 -0.08687522 -0.16021478 0.23487245 0.17879948 -0.087380715 0.350689 -0.14675008 -0.34439364 0.507477 -0.10131176 0.51448363 0.66783947 -0.25688875 0.07498477 0.22809404 -0.14670335 -0.24556562 -0.09267838 0.20939386 0.012338808 -0.0049652797 -0.38581255 0.25593153 0.24142446 0.07390061 -0.5554781 -0.25503945 -0.1986268 0.32011613 -0.34113613 -0.3579774 0.005956616 0.32497618 0.58551735 -0.1428784 0.04846568 -0.019735275 0.31149343 -0.6008044 -0.41959283; -0.074051686 0.12275755 0.20773147 -0.4714986 0.11687995 -0.11924884 -0.066050805 -0.043652598 0.06314157 0.49969015 0.5983828 -0.21293204 -0.4535226 -0.2043579 -0.46054208 0.16633698 0.2913221 -0.5303219 0.08852923 0.04707242 0.5476204 -0.46989226 0.5672569 0.29329222 -0.003293535 0.061964776 -0.52236533 0.14555827 -0.5425697 -0.21387684 0.0130346315 -0.3056692 0.4481199 0.44380623 -0.38725013 -0.04343981 -0.3758996 0.37160617 -0.25305152 -0.5268981 0.49551082 -0.37140238 -0.023942545 -0.3869301 0.37131217 -0.07621719 0.6440993 0.023880763 -0.16851592 -0.4568819 -0.03045191 0.38283727 -0.0018052793 0.44475442 0.20580679 -0.486898 -0.28137392 -0.26258603 -0.2520221 0.5058275 0.23654784 -0.1407439 -0.36508328 0.13963003 -0.4631381 -0.20727193 0.10597562 -0.19714291 0.16382328 -0.08176821 -0.065141566 -0.6200307 0.08111065 0.10964742 -0.23183812 0.54287225 -0.28887615 0.11784811 -0.3197296 -0.37908065; 0.41500995 -0.30491632 -0.15076129 0.3854828 0.18725432 -0.5373823 -0.1751562 0.49491033 -0.46960863 -0.17168875 -0.32272762 -0.49699473 0.46082702 0.15747507 0.009113039 0.39711308 -0.38243586 0.27261952 -0.25690883 -0.5776839 -0.35504553 0.22193739 -0.4516158 -0.46746996 0.34990165 -0.17376138 0.13157925 -0.3764092 0.40201348 0.51523066 -0.5353551 0.029991653 -0.30435997 -0.4444137 0.16534334 -0.38015383 0.48614013 -0.43407562 0.34089637 0.3309986 -0.16100393 0.41051438 -0.5576807 0.39920214 -0.39592156 -0.5648135 -0.48376092 0.44395348 -0.38336337 0.13816823 -0.46727008 -0.36015257 0.22402492 -0.12852764 -0.35834223 0.19460016 0.27101377 0.2458695 -0.58130974 -0.38006225 -0.11925523 0.14111152 0.0968628 -0.335267 0.35869968 0.21775615 0.18022805 0.5081244 -0.47635406 0.25645918 0.40727314 0.25447682 -0.36880857 -0.23109965 0.48274958 -0.4640385 -0.3994113 -0.3317547 0.30638766 0.42365935; -0.022631355 0.06477811 -0.38128558 0.3201529 -0.20106088 0.25977316 0.102188185 -0.18296717 0.13811004 -0.50173515 -0.33600813 -0.008502717 0.257514 0.49419758 0.2909632 -0.06251721 -0.4425589 0.44816455 0.19021949 0.17377561 -0.51110804 0.41583946 -0.25755608 -0.38079044 -0.28399846 -0.18465473 0.64484864 -0.3144588 0.49354443 -0.27640903 0.15633444 0.25686732 -0.5010858 -0.52456206 0.26668626 -0.14370088 0.36896005 -0.5002696 0.40782416 0.47347322 -0.34822357 0.2744095 0.123334 0.5445038 -0.32227135 0.018471511 -0.44671127 -0.26879236 -0.055309385 0.48243725 0.056923382 -0.3214251 0.1440336 -0.25022206 -0.34484458 0.42544538 -0.030356286 0.2653685 0.007653311 -0.2532876 -0.604029 0.22231464 0.35925707 -0.09914415 0.48884255 -0.07702987 0.16705543 0.26066676 0.007990724 0.07811293 -0.097423054 0.38799328 0.18429303 -0.06266702 0.5695046 -0.5640399 0.28968564 -0.031220013 0.36310062 0.4443622; 0.013531153 -0.0356628 0.3896187 -0.30783713 0.054370526 -0.24812233 -0.06031036 0.21764727 -0.07135378 0.34051746 0.5433841 -0.09287618 -0.43477705 -0.4056467 -0.17130181 0.06175536 0.35375595 -0.4375962 -0.116582066 0.0135411145 0.45801637 -0.60573465 0.44457433 0.44433168 0.036090545 0.19203787 -0.3127794 0.39775684 -0.30383447 -0.016099982 -0.1623261 -0.37262335 0.21681303 0.53224397 -0.5366925 -0.0771545 -0.610729 0.41605815 -0.39429292 -0.6018482 0.24956173 -0.52297777 -0.115474276 -0.5908011 0.2607128 -0.13419321 0.37281987 -0.07879209 -0.115769334 -0.5286165 0.12907098 0.17643245 0.058571484 0.331573 0.35862213 -0.44077864 -0.29391685 -0.4586246 -0.24096593 0.28249475 0.32048652 -0.17197536 -0.3094382 -0.08761274 -0.35860163 -0.23615438 -0.0833677 -0.33568895 0.27067778 0.05796276 -0.053388022 -0.4877256 0.13020012 0.0028285661 -0.22906697 0.61041737 -0.31957403 0.073759355 -0.4301143 -0.19630471; -0.24246198 0.2947737 0.4467871 -0.44149238 -0.44755384 0.34735602 0.28369156 -0.26510504 0.21546268 0.49572125 0.06787051 0.2858294 -0.4366571 -0.101761095 -0.04605146 -0.38886976 0.48986307 -0.017040763 0.3508955 0.38838947 0.0838967 -0.2358759 0.39347795 0.49311367 -0.365823 0.4537504 -0.20531884 0.51642966 -0.106826276 -0.41787314 0.6587038 0.12885182 0.47738048 0.24107908 -0.21265298 0.4934893 -0.36751965 0.4993068 -0.042493194 -0.15528095 0.14586079 -0.10294701 0.23288628 -0.10263394 0.19892077 0.55083936 0.15489277 -0.29991427 0.5476966 -0.31557554 0.44466332 0.46029168 -0.292525 -0.13732068 0.22675289 -0.3128751 -0.24975465 -0.12778807 0.4377392 0.055875175 0.25769117 -0.51568395 -0.008818758 0.25359857 -0.25241855 -0.3927917 -0.16909333 -0.441265 0.43243653 -0.5420043 -0.22069451 -0.28262562 0.28222424 0.5089886 -0.20134756 0.12251834 0.46696308 0.35430026 -0.19228381 -0.52066165; 0.2999784 -0.116005875 -0.43347573 0.29457983 0.11828111 -0.03425785 -0.22187501 0.08114571 -0.15940799 -0.503512 -0.5249944 -0.07943001 0.2033983 0.3372834 0.39343923 -0.012446159 -0.21416837 0.485393 -0.24334668 -0.06430564 -0.25934952 0.51695496 -0.28792015 -0.24737954 0.26243505 -0.24066699 0.46579108 -0.48073965 0.43996763 0.143404 -0.089929886 0.30658486 -0.22677825 -0.3552804 0.4154761 -0.17356685 0.24511626 -0.24802628 0.36866048 0.43646294 -0.31009856 0.3383221 -0.095533594 0.56067854 -0.31108367 -0.43855074 -0.17982168 0.15031767 -0.14544113 0.3514934 -0.3406899 -0.26761964 0.23230961 -0.32938805 -0.29614323 0.2986031 0.3881889 0.24625756 -0.036801 -0.24007726 -0.28161675 0.28302693 0.61895275 -0.2390757 0.4419881 0.18583795 0.28973588 0.48278588 -0.31908062 0.11779511 0.2934979 0.256468 -0.29273048 -0.4136698 0.48107818 -0.37354353 0.045185715 -0.2813091 0.2500076 0.2644134; -0.37890577 0.5063047 0.4774743 -0.2659855 -0.4271274 0.42226762 0.38640353 -0.53206784 0.24909265 0.29497778 0.23930816 0.57608354 -0.39217478 -0.35767123 0.07467858 -0.5789131 0.17883687 -0.10625196 0.5368413 0.45766997 0.03976269 -0.097855516 0.265767 0.27807724 -0.40986374 0.5144641 -0.21787058 0.4302538 -0.3751956 -0.4891194 0.29146498 -0.18342966 0.19115803 0.41797715 -0.089385375 0.48418492 -0.21928898 0.24259903 -0.29872406 -0.0909563 0.2643875 -0.3376205 0.3418532 -0.19214669 0.45080146 0.55255175 0.37257385 -0.5863603 0.48077193 -0.37198684 0.3257508 0.3545007 -0.4030499 0.27649727 0.44765127 -0.33246702 -0.2777305 -0.25088462 0.56105137 0.074017674 0.17093882 -0.16744371 -0.049522292 0.16460907 -0.23339914 -0.514246 -0.28102824 -0.4276283 0.16424863 -0.52842206 -0.26168376 -0.14807281 0.44275302 0.18360718 -0.13008706 0.38431016 0.2908129 0.43941417 -0.34978732 -0.21883188; -0.12036376 0.019070134 0.3379204 -0.4127863 -0.04614122 -0.16003059 -0.020136219 0.0173748 0.17147852 0.47183323 0.6187539 -0.06765217 -0.27145544 -0.48116568 -0.21904674 0.221782 0.48011252 -0.54844683 0.19694659 -0.07976039 0.33505052 -0.4024208 0.5897378 0.21864435 0.062578924 0.22470029 -0.40622902 0.34366465 -0.37609035 -0.10955618 -0.049116284 -0.5035971 0.24247824 0.2689715 -0.44630337 0.00912364 -0.4486725 0.45701247 -0.50736386 -0.24980058 0.53337836 -0.2812132 0.23030674 -0.4534277 0.37529036 0.060049076 0.5460398 -0.047136854 0.33080834 -0.5559341 0.36384314 0.35325694 -0.018820653 0.27308515 0.31133434 -0.29725322 -0.3302223 -0.32494095 0.005641526 0.36521572 0.28525496 -0.2732137 -0.33166325 0.10008013 -0.27024373 -0.3774136 -0.2726572 -0.46330765 0.2534576 -0.2548735 0.13774729 -0.46250373 -0.094423085 0.28222197 -0.30189955 0.42844918 -0.09129919 0.26850817 -0.39286417 -0.4761762; 0.04626507 -0.09223891 0.24664152 -0.2781502 0.075220935 -0.31187975 -0.13998957 0.33591577 -0.18638031 0.4963805 0.41281247 -0.19233814 -0.1775753 -0.4144535 -0.27665117 0.014491411 0.438451 -0.5359116 0.03258919 0.010266114 0.3771832 -0.37497216 0.22814777 0.3459053 -0.008141827 -0.24425857 -0.36736563 0.34200084 -0.3437409 -0.038094465 -0.018886657 -0.3323333 0.6031706 0.5450985 -0.32097578 0.01196142 -0.58032525 0.53445303 -0.31601962 -0.5007841 0.17874968 -0.47027853 -0.1531938 -0.32049045 0.5408452 -0.0376991 0.52055925 0.28030136 -0.030621361 -0.2961578 -0.20247798 0.49808958 -0.086811304 0.3013755 0.003953475 -0.39686993 -0.090565816 -0.47195056 -0.14807442 0.45605424 0.2748273 -0.31510985 -0.46748444 -0.09679067 -0.5362668 0.04076954 0.16848582 -0.18429758 -0.20707668 0.16624144 0.08260799 -0.57714146 -0.12598027 -0.10701707 -0.29409552 0.33044824 -0.08957494 -0.20311685 -0.33048567 -0.037614092; -0.28715363 0.059612174 0.49902022 -0.33791834 -0.19007978 -0.1780113 0.34028676 -0.033780888 0.3058981 0.19958413 0.28668988 -0.2212286 -0.42965156 -0.37023577 -0.43368813 -0.009356569 0.56476235 -0.36278784 0.1156329 0.101403296 0.5222082 -0.3411478 0.4774332 0.20489222 -0.08927336 0.16423959 -0.24619524 0.16060282 -0.3770302 -0.06314421 0.049460318 -0.41256362 0.18817014 0.5238044 -0.315765 0.017337171 -0.24970402 0.3874994 -0.60540676 -0.3152244 0.23600833 -0.40016487 -0.04389771 -0.30788162 0.25016254 0.2035748 0.4514224 -0.09922277 0.17839219 -0.25736567 0.091695674 0.2073773 0.055501487 0.54389185 0.14921692 -0.46859217 -0.3384608 -0.62973917 -0.24954458 0.28156343 0.56836385 -0.46837777 -0.44095606 -0.004602449 -0.3862626 -0.3525809 -0.13202623 -0.3476392 0.3023996 -0.28348744 0.1354716 -0.4516584 0.12624638 0.28311846 -0.28644288 0.5766389 -0.33772543 0.006895305 -0.3139357 -0.48941752; 0.16420612 0.10489083 0.024383923 0.30155733 -0.1502234 0.18994415 0.14100903 -0.16416669 0.064015135 -0.5144089 -0.40982234 0.06730515 0.36438197 0.3090075 0.36074716 -0.2850031 -0.5552345 0.27050918 0.2740227 -0.036419466 -0.19764122 0.17133836 -0.29998398 -0.6109761 -0.022829691 0.12359039 0.6147882 -0.4467602 0.57315356 -0.25686184 0.24729225 0.24373034 -0.34883767 -0.39710417 0.4855228 0.09638375 0.35992014 -0.45359308 0.3624747 0.40852478 -0.3275659 0.5089618 -0.037374545 0.30956748 -0.5294336 0.19262595 -0.3899093 -0.011079503 0.080622345 0.4214894 0.30283067 -0.25516105 -0.12014326 -0.48068896 -0.14336045 0.25035018 0.12337442 0.5481135 0.19008651 -0.5774133 -0.39639112 0.23398127 0.3712503 -0.039157804 0.29234603 0.006984598 0.07378557 0.31820235 0.07796729 -0.24900758 -0.25958937 0.43579143 -0.007699111 0.040460877 0.5349747 -0.37949994 0.03954419 0.09532811 0.121961966 0.1548123; 0.6019162 -0.45529237 -0.23100245 -0.07949732 0.5642884 -0.4306429 -0.5092993 0.32814974 -0.2263799 -0.22200815 -0.08109657 -0.18041624 0.34429082 -0.102560446 -0.1835981 0.289319 -0.19532423 -0.0011508234 -0.32506758 -0.4729943 0.040037256 -0.17386635 0.13655147 0.061902042 0.26788923 -0.6131222 -0.07950569 -0.1474156 0.057457495 0.3998795 -0.30947924 -0.33691916 -0.32465002 0.0494706 -0.008710837 -0.2821574 0.13517547 -0.2874273 -0.15990399 -0.12688038 0.1873679 -0.03459554 -0.29915795 -0.03164689 -0.021735128 -0.23875092 0.03331308 0.17814569 -0.37143627 0.13561855 -0.37408075 -0.42941478 0.3856452 0.19273946 -0.2575191 -0.04621541 0.429319 0.04055035 -0.24393433 0.24302551 0.0823429 0.48156923 -0.30008566 -0.23557737 -0.025470097 0.4879794 0.433178 0.42907536 -0.4041381 0.22142164 0.5489973 -0.21949065 -0.38609642 -0.23495968 -0.13101748 0.13548514 -0.23011565 -0.50472826 0.37869444 0.48596194; 0.29821667 -0.21831907 -0.3171134 0.019558897 0.34030882 -0.43920806 -0.2554327 0.22647995 -0.5926957 -0.15235811 -0.016525207 -0.38618305 0.40103444 -0.105529875 -0.00993158 0.29758668 0.08283405 0.04326238 -0.26759574 -0.3931685 0.20793107 -0.016586121 0.14002705 -0.35490888 0.37666982 -0.29391044 0.029610524 -0.25483373 0.2074649 0.38313204 -0.5034339 -0.041718002 -0.071962915 0.14666548 0.028523812 -0.37779865 -0.07813232 -0.28554276 0.0042883535 0.002042047 0.026801558 -0.21431828 -0.358869 -0.023698116 0.061933126 -0.51146877 0.043697905 0.36070177 -0.55400383 0.03364039 -0.46024302 -0.5311178 0.38086838 -0.02630721 -0.31244913 0.029488793 0.42323697 -0.17572652 -0.3693357 0.299396 -0.014518535 0.47024232 -0.27918777 -0.5032181 -0.12798484 0.6014919 0.35549915 0.30907863 -0.38420445 0.41676414 0.22430581 0.16284803 -0.2568625 -0.40404668 -0.06071656 0.13145776 -0.10008624 -0.35936084 0.5660581 0.3404784; 0.14993195 -0.05300282 0.27309662 -0.45684162 0.14341426 0.040952433 0.07652721 -0.043501068 0.03859353 0.4042665 0.29839647 -0.012667303 -0.08871832 -0.56850064 -0.21681193 -0.07403474 0.22637741 -0.5733918 -0.289261 -0.15578125 0.3255775 -0.49780765 0.4650751 0.49877927 -0.022424772 0.16823772 -0.3658516 0.21790725 -0.5501396 0.055220682 -0.30446967 -0.20486861 0.27640575 0.5607988 -0.25465113 -0.18686736 -0.5627818 0.46942797 -0.45989653 -0.51962155 0.57575375 -0.23179246 -0.21870415 -0.2856047 0.5769774 -0.018987248 0.50133675 0.3005127 -0.25574875 -0.3166069 0.09177236 0.47918314 0.21764389 0.25185174 0.075570755 -0.28778216 -0.0755374 -0.48275042 -0.15485087 0.2932966 0.53194845 -0.26184684 -0.26711637 0.18418972 -0.21228956 -0.119532764 -0.1712276 -0.5194453 0.060773857 -0.006300681 -0.009078695 -0.49030125 -0.035972137 0.05615436 -0.36684924 0.50848436 -0.1557438 0.07671261 -0.2470722 -0.32363358; 0.3513245 -0.24011986 -0.44088894 0.06170078 0.36725882 -0.22358727 -0.25448766 0.4127463 -0.34195775 -0.4431355 -0.04082484 -0.37853348 0.17997639 -0.10172061 -0.019368336 0.3796834 -0.19568314 0.019465163 -0.64863116 -0.3547189 -0.10151838 0.067245744 -0.28148773 -0.4782943 0.3847924 -0.25714776 0.26896006 -0.41284707 0.43054062 0.57068497 -0.36845133 -0.19412501 -0.24707514 -0.256023 0.078317955 -0.52055687 0.15662965 -0.33500037 -0.022277812 0.024064291 0.14623837 0.14799267 -0.46019906 0.043996546 -0.27289906 -0.2982925 -0.12890552 0.49155298 -0.539722 0.02908309 -0.2654741 -0.45506546 0.29370993 -0.09525865 -0.2928527 0.15674634 0.41089103 0.36374283 -0.42683887 0.13229172 -0.0969765 0.34323093 -0.24097748 -0.47293156 0.18700844 0.43040153 0.45044044 0.38576335 -0.2506106 0.54839236 0.5123758 0.3376259 -0.55650455 -0.36872807 0.09570362 -0.3801463 -0.20700203 -0.2889425 0.5226232 0.5485108; 0.05067572 -0.022955367 -0.3504805 0.56887245 0.08854921 0.0054310174 0.1189182 -0.07398657 -0.07329635 -0.5678677 -0.21318522 0.27036875 0.25264376 0.5548147 0.42440164 -0.090429366 -0.44576436 0.39824855 0.009986551 0.038686708 -0.18496674 0.50310415 -0.52849257 -0.5935667 -0.17468722 0.053099133 0.58266014 -0.47620094 0.34791625 -0.09396242 0.19760586 0.38875946 -0.3112208 -0.44250116 0.3306547 -0.062055368 0.55423397 -0.26907793 0.4872137 0.44009605 -0.49071226 0.56434125 0.09940019 0.35683835 -0.5733301 0.11888551 -0.58392096 -0.0069234218 0.22475946 0.53789335 -0.045807887 -0.42445025 -0.2048633 -0.4884371 -0.2914905 0.28138915 -0.08119293 0.40665013 0.28535244 -0.21704972 -0.5493923 0.16377583 0.19501024 -0.097874604 0.34515715 -0.09733611 0.003928822 0.3974006 0.03192877 -0.0862763 -0.19895275 0.4273401 0.19710109 -0.04319677 0.50236213 -0.53559375 0.29554707 0.1485967 0.43131408 0.37465027; 0.51870143 -0.4627086 -0.3146351 0.25387043 0.4174413 -0.3678957 -0.47619703 0.2998013 -0.3098728 -0.25541437 -0.20787916 -0.282623 0.28350508 0.12075524 -0.1829174 0.44464478 -0.46323192 0.07605821 -0.50343347 -0.34511662 -0.03345757 0.40430734 -0.3397049 -0.20148462 0.39613637 -0.5036403 0.20659856 -0.20880634 0.18124051 0.30955827 -0.3387931 -0.13007267 -0.48071614 -0.35007802 0.19366771 -0.5097594 0.46998912 -0.3110409 0.13090904 0.42832136 -0.23054846 0.31929183 -0.22259462 0.29042414 -0.3772707 -0.5480001 -0.39465365 0.5046362 -0.4190244 0.33037877 -0.52181333 -0.5442477 0.2722593 -0.0800175 -0.40345466 0.34663764 0.2777076 0.31833538 -0.5263775 -0.20678777 -0.32203442 0.4180637 0.0831715 -0.36993626 0.39547262 0.24809569 0.19084367 0.37601838 -0.22033514 0.25904262 0.3733403 0.19831795 -0.442777 -0.35714236 0.39284608 -0.18640709 -0.24757467 -0.4159425 0.49256498 0.3409314; 0.27248853 -0.5442755 -0.26724905 -0.12819736 0.37125957 -0.34200978 -0.3283321 0.2667226 -0.57507205 -0.40387228 0.022992821 -0.42804924 0.45295185 -0.0865108 -0.31620735 0.51301545 0.01983158 -0.21833186 -0.5658929 -0.26700306 0.07238195 -0.100971445 -0.11460627 -0.32668105 0.41259557 -0.45966488 -0.06847974 -0.41690856 0.017855616 0.376563 -0.49258387 -0.11628764 -0.115491055 0.009433279 -0.079947524 -0.42856959 0.1872375 -0.17548865 0.0017084497 -0.18524167 0.088594355 0.08610435 -0.5245036 -0.038179833 -0.08236919 -0.26197964 0.05161326 0.333745 -0.3817141 0.21679541 -0.51511097 -0.32324454 0.2452997 0.33391044 -0.5988367 0.19970204 0.25171223 -0.13891198 -0.33281952 0.095495194 -0.0719045 0.3570026 -0.20397918 -0.36691606 -0.23933072 0.5780072 0.4317995 0.36421546 -0.5073817 0.56794107 0.3132599 -0.051276717 -0.44127813 -0.33407953 0.18997575 -0.1520794 -0.24234731 -0.5288004 0.2430327 0.53455114; -0.390685 0.2648141 0.22751468 -0.004447897 -0.55531746 0.095547974 0.43918106 -0.2968452 0.324227 -0.28708145 -0.24305387 0.20789883 -0.5013139 0.21062711 0.1797519 -0.016541995 -0.18825117 -0.004619919 0.10464313 0.24612482 -0.06824212 0.11218111 -0.3122167 -0.32421035 -0.33540568 0.45986447 0.20695399 -0.18641372 -0.028702663 -0.2559025 0.33060208 0.17979302 -0.010522539 -0.29850498 0.2742481 0.1721046 0.29657254 -0.15991999 0.06312606 0.24306744 -0.1482978 0.024769543 0.33034647 -0.006048229 -0.07511735 0.39224985 -0.19806738 -0.10817624 0.5321773 0.17893869 0.14799096 0.23667113 -0.49463376 -0.13026068 0.27861568 -0.0026008047 -0.5207217 0.31995785 0.15544641 -0.24015102 -0.2198925 -0.39367256 0.11665269 0.3248251 0.18487547 -0.26561648 -0.45634907 -0.07696874 0.4642993 -0.44365606 -0.4729354 0.16762011 0.41493958 0.29225895 0.28703424 0.0060352753 0.20315863 0.48161834 -0.5120421 -0.4259341; -0.45474663 0.18640515 0.1647283 -0.43658453 -0.19753195 0.016478384 0.4418242 0.094828226 0.14903803 0.4527402 0.23096521 -0.20028542 -0.35852018 -0.4186576 -0.51027995 0.11273223 0.28453243 -0.36516368 0.15664387 0.010464907 0.5423272 -0.24706389 0.5821269 0.29284352 -0.057652336 0.30834013 -0.5529076 0.38931346 -0.36087322 -0.351766 -0.055174865 -0.321174 0.21613489 0.28391862 -0.32642806 0.12536918 -0.20535801 0.21233954 -0.3867034 -0.4928379 0.29852998 -0.32205015 0.11489956 -0.5157879 0.5806191 0.06325356 0.2891107 0.07930229 0.35277212 -0.45841533 0.34012234 0.3464387 -0.2614112 0.5633235 0.33788484 -0.5596909 -0.44858465 -0.35432667 -0.17038925 0.52118725 0.41106692 -0.20777357 -0.35927293 0.14745435 -0.40873256 -0.39144528 -0.4001859 -0.34627452 0.43590283 -0.14002798 -0.33409125 -0.22412287 0.27089673 0.077245206 -0.51523876 0.1883875 -0.099419914 0.45012373 -0.2308013 -0.2971434; -0.19713843 0.05729103 0.21393615 -0.45838925 -0.013977951 -0.2504903 0.22617339 -0.04169569 0.16515586 0.4599222 0.4819037 -0.2898614 -0.13812557 -0.36309132 -0.48200104 0.088256195 0.29769212 -0.55255824 0.14657283 -0.1833745 0.3466653 -0.5709031 0.29065976 0.41438198 0.03647236 0.029456269 -0.44050673 0.46742833 -0.51765126 -0.110759646 0.069190085 -0.32896134 0.27129787 0.3596074 -0.5016877 0.009455409 -0.2952257 0.42327657 -0.2085229 -0.3055558 0.288528 -0.6552445 -0.09623503 -0.34180403 0.5064138 0.11014389 0.5871807 0.23417592 0.15648954 -0.3812238 0.008487491 0.15750141 0.015844151 0.22686374 0.4653066 -0.27966374 -0.13091727 -0.5218273 -0.22255018 0.58343947 0.55666524 -0.4953459 -0.4014935 -0.064079076 -0.35502225 -0.039508924 0.006746752 -0.4198445 0.33605403 -0.015177169 0.038472094 -0.25140494 0.07137585 0.21536772 -0.46659696 0.46444476 -0.31082734 0.23399295 -0.43386343 -0.28364596; -0.04989189 -0.15343653 0.13944939 -0.5232893 0.051791843 -0.2808347 -0.017034933 0.27168489 -0.028052285 0.5244473 0.48155856 -0.26145723 -0.34846744 -0.52585363 -0.19421823 -0.027129078 0.44141018 -0.42993596 0.08401304 -0.24685049 0.4087891 -0.4305186 0.53911275 0.5630166 0.17609134 0.12049831 -0.46984968 0.5111554 -0.48109004 -0.022951819 -0.050791007 -0.26666844 0.32140547 0.22512445 -0.4261205 -0.038376004 -0.3442365 0.2913468 -0.44051158 -0.58926696 0.5315836 -0.5527809 0.059052132 -0.6042513 0.3113576 -0.1655087 0.4605525 -0.028703533 0.013706075 -0.5723726 0.1502089 0.25647485 -0.18690622 0.3608847 0.29622316 -0.4031013 -0.04276482 -0.27060717 -0.14299835 0.47124815 0.40820977 -0.23291706 -0.3587338 0.075010486 -0.33110908 0.063694544 -0.15635258 -0.47683996 0.16809112 -0.025515933 0.18367662 -0.252852 0.020666705 0.0014020178 -0.6009707 0.4439423 -0.08592673 0.0908672 -0.1773785 -0.22125003; -0.59659636 0.485097 0.3908722 -0.10369325 -0.58109194 0.4681566 0.44546115 -0.22194612 0.33073258 0.29982057 0.15977223 0.560751 -0.20014277 0.07532335 0.11878971 -0.25830147 0.2855284 -0.0024186766 0.27446482 0.44746086 0.091938674 0.09954487 0.15942124 0.084357284 -0.3824848 0.4097791 -0.2041308 0.14763455 -0.21365902 -0.35418978 0.25323713 0.0275678 0.49871215 0.1779316 0.052240036 0.64666086 -0.043336973 0.36678585 0.22714563 0.14056738 -0.013922102 -0.03556583 0.6169765 0.12615198 0.059010327 0.29687798 0.09819489 -0.4692674 0.55010235 0.00031111168 0.41926172 0.2377364 -0.27379265 -0.02702083 0.35719472 -0.38415867 -0.5355406 -0.26378912 0.41595384 0.040825356 -0.06465461 -0.41289276 0.13266894 0.26486877 0.021724561 -0.31433266 -0.5817621 -0.16683134 0.515639 -0.42956412 -0.22679378 -0.07940171 0.3186851 0.5317438 -0.24913101 0.25423035 0.4865957 0.3548491 -0.4811835 -0.20487931; -0.19454823 0.26904094 0.2683226 0.13019304 -0.21026736 0.54472375 0.38891518 -0.08194124 0.33932433 0.16140467 -0.016998887 0.3623495 -0.29152536 0.31431013 0.1124523 -0.5212013 -0.1265667 0.21925494 0.48069996 0.40534362 -0.24084038 0.19754429 -0.19631188 0.067383535 -0.19537608 0.5622952 -0.073603086 0.4156549 0.17008637 -0.39623362 0.35685557 -0.031354252 0.14751652 -0.2246734 -0.031741086 0.41663843 0.236999 0.343215 0.15504175 0.06194978 -0.16084701 0.13523531 0.3817415 0.14086135 -0.20472856 0.51360875 -0.091676 -0.25527227 0.3918159 0.086791076 0.43320355 0.38238147 -0.55806494 -0.2682363 0.45838064 0.027942644 -0.29426703 -0.031183919 0.007919063 -0.09580073 0.008536814 -0.5189381 0.028754769 0.22368418 0.06322241 -0.47306687 -0.3103332 -0.0041360375 0.5272827 -0.21674943 -0.3596985 0.19091296 0.22309136 0.43040138 -0.01879815 -0.06482861 0.3120513 0.30654457 -0.35684395 -0.44756183; 0.2613639 -0.2772924 -0.3644317 -0.009704962 0.2885653 -0.53947526 -0.4785301 0.29244795 -0.24520908 -0.1305806 -0.10634554 -0.4875114 0.39144143 -0.2450877 -0.25217772 0.23985538 -0.31963098 -0.26833937 -0.27360988 -0.3329092 0.18291807 0.21587186 -0.15634748 -0.10638404 0.3074509 -0.43834537 0.2469324 -0.14132912 0.40525863 0.45185223 -0.26401544 -0.07742147 -0.34475884 -0.21598063 -0.09504248 -0.62666357 0.067006715 -0.16906793 0.121122636 -0.046824977 0.0032259498 -0.02857071 -0.3142585 -0.17098476 -0.14278759 -0.43345383 -0.09186429 0.41571438 -0.31594324 0.09688776 -0.45449653 -0.26585755 0.60778683 0.26598525 -0.31168762 0.30843952 0.48728165 0.1180879 -0.37269998 0.1627432 0.0054457053 0.5303645 -0.21945344 -0.5608874 -0.11833209 0.4079972 0.5146939 0.2218701 -0.3585938 0.48488542 0.52122766 0.22281708 -0.50786656 -0.34142795 0.07552119 -0.1820096 -0.24585125 -0.24557681 0.3184272 0.21189985; -0.4997194 0.2881626 0.42764238 -0.40897444 -0.35716724 0.45137194 0.3294806 -0.50241154 0.2731791 0.3325662 0.2873011 0.6126003 -0.30395624 -0.17271735 0.08572423 -0.45382738 0.4241362 -0.17260179 0.3791544 0.29880914 0.13488577 -0.22552139 0.31645915 0.27681983 -0.35999835 0.48205468 -0.30624563 0.31586105 -0.41139367 -0.4166113 0.4598951 -0.027573215 0.46687272 0.36205238 -0.34854496 0.2798288 -0.37270817 0.1649943 0.0076309675 -0.07650072 0.13945054 -0.33924124 0.5079543 -0.05863299 0.4013662 0.30783847 0.42762643 -0.25441468 0.4072114 -0.3898664 0.3343955 0.37678358 -0.3501062 0.017853387 0.35447618 -0.1806511 -0.38578045 -0.17293091 0.50672674 0.17131701 0.22033326 -0.20775701 -0.069028646 0.5467618 -0.39407828 -0.3786062 -0.25950038 -0.46948466 0.45213225 -0.39269868 -0.24145423 -0.3403164 0.2983552 0.54113036 -0.35608974 0.2186152 0.34335116 0.27083737 -0.3424052 -0.25434867; -0.43992186 0.390974 0.34393102 -0.32781437 -0.43296987 0.59986633 0.5602649 -0.20950729 0.26197654 0.3898479 0.36052608 0.476672 -0.500359 0.031309675 0.2736809 -0.3935813 0.2984999 0.003597933 0.29234627 0.5256767 0.20607014 -0.07234562 0.35270065 0.10142507 -0.54308474 0.21813546 -0.25468755 0.22869067 -0.3467318 -0.33235845 0.2831111 0.21267895 0.4738408 0.043369662 -0.14976436 0.3155834 -0.24490355 0.25616625 -0.15030847 -0.21498019 0.035993174 -0.29316825 0.30184653 -0.15788092 0.2973627 0.24562752 0.27605802 -0.46487606 0.53612524 -0.26365823 0.5224609 0.13042413 -0.3103915 -0.19113946 0.51233256 -0.19522649 -0.40090832 -0.35113826 0.43316063 -0.111656174 0.22324099 -0.21470511 -0.10490507 0.39878473 -0.1856675 -0.5632336 -0.5605442 -0.31616792 0.2953737 -0.49940234 -0.5417353 -0.1724281 0.2724584 0.36333 -0.123834595 0.41605988 0.30131757 0.21375653 -0.29373094 -0.19007677; -0.26265493 0.0642906 0.2636839 -0.31197396 -0.011929388 -0.06823313 -0.100589775 -0.051627122 -0.117886476 0.4173112 0.3051881 -0.16872375 -0.28651702 -0.23455428 -0.21691892 0.296132 0.23926522 -0.28989682 0.073668964 -0.17401648 0.2699389 -0.5119279 0.2952727 0.579725 0.13812535 -0.034833573 -0.551275 0.32786888 -0.31876907 -0.17936212 -0.05719279 -0.5101513 0.5659859 0.46806395 -0.50570726 -0.00485464 -0.2665753 0.37084413 -0.50182635 -0.56275207 0.4508399 -0.46292394 0.12807678 -0.2384813 0.31898978 0.047416728 0.47667876 0.043636955 -0.105098 -0.5626767 0.2038424 0.16879864 -0.13238844 0.37905398 0.10828906 -0.384637 -0.16813575 -0.39672744 -0.20194039 0.19617248 0.49723008 -0.21136315 -0.35501176 0.18049066 -0.35083959 -0.06474585 -0.12757057 -0.17883019 0.081510246 0.1725109 0.10919196 -0.49726975 -0.10028758 -0.02833921 -0.27493593 0.44158825 -0.15234365 -0.018234441 -0.2442142 -0.3111013; -0.058490608 0.14688458 -0.40078673 0.39158607 -0.04865809 0.036816046 0.07006874 -0.06313654 -0.08406953 -0.35184792 -0.56010765 0.14173073 0.30074278 0.25877506 0.21819532 -0.05243066 -0.48446238 0.43463412 -0.03402422 -0.054020837 -0.41042465 0.44037125 -0.3616599 -0.36849114 -0.30051157 -0.14712974 0.53314424 -0.22759464 0.5224638 -0.12127113 -0.03507619 0.3999086 -0.5403646 -0.25613832 0.28874108 0.076726526 0.55405885 -0.19377951 0.3064302 0.45588374 -0.4204152 0.58839875 0.021719882 0.26256338 -0.38809672 -0.039545696 -0.54260254 -0.27645123 -0.068789996 0.32091275 0.13089305 -0.4604033 0.024774438 -0.23097636 -0.11280347 0.4685718 0.2028223 0.41663605 0.040559888 -0.41110963 -0.4692026 0.25958782 0.2863993 0.2117802 0.3765503 0.203433 0.08827501 0.42848226 -0.28226274 0.090854704 0.07047552 0.34852847 -0.06140584 -0.06633113 0.47362897 -0.37587503 0.32873756 -0.17405497 0.19986783 0.09537782; -0.32967702 0.120024465 0.31859225 -0.34818882 -0.3447665 -0.16203354 0.32463807 0.18650293 0.32112226 0.28933713 0.26525408 -0.23133276 -0.45069855 -0.62639195 -0.24042484 -0.1451625 0.28306586 -0.45912787 0.15995553 -0.06772441 0.40980288 -0.53480345 0.26656488 0.1927564 0.11031521 0.261967 -0.25057423 0.18969803 -0.36388496 -0.11245963 0.057477605 -0.5087225 0.307861 0.3482419 -0.40610462 0.271878 -0.41345903 0.21772552 -0.63646597 -0.36638063 0.5930005 -0.5060694 0.10128024 -0.50980866 0.2361004 0.2832568 0.27015463 0.1628889 0.18935247 -0.4582004 0.4287485 0.16335687 -0.3753552 0.26602733 0.33905923 -0.22610891 -0.17417197 -0.39660463 -0.22015858 0.44138092 0.54538536 -0.33282268 -0.27458784 0.35964927 -0.5310205 -0.16643319 -0.29061761 -0.19943929 0.34151712 -0.30533966 -0.016964123 -0.21290454 0.24976413 0.064384416 -0.21915416 0.33069298 -0.27552748 0.26332152 -0.12556805 -0.4115419; 0.31003964 -0.40858322 -0.19468033 0.16705203 0.5476674 -0.2739871 -0.23871319 0.43205118 -0.5495929 -0.37031707 -0.14030594 -0.4881033 0.2882148 -0.21882926 -0.0068438076 0.41281286 -0.25666508 0.03488284 -0.39827594 -0.2933119 0.14009003 0.14106192 -0.011674438 -0.18125652 0.54090005 -0.4305644 0.18485115 -0.25537285 0.41477305 0.5648081 -0.26703647 -0.14738166 -0.24730197 -0.09757422 -0.19581804 -0.5199224 0.39891753 -0.2641714 -0.052153185 -0.02679207 -0.044543862 0.0084334705 -0.40318722 0.08394335 0.025341813 -0.48719618 -0.08957162 0.29440668 -0.31364882 0.08336417 -0.26634392 -0.3367465 0.2806189 0.037999503 -0.35266238 0.38964066 0.43512145 0.11130596 -0.19711435 0.21937084 0.1184777 0.4345923 0.01084418 -0.5296158 0.008787618 0.56811947 0.3157153 0.3962034 -0.42413238 0.51251185 0.40699145 0.24162492 -0.3965767 -0.52265066 0.10004965 -0.33858222 -0.20137908 -0.47668955 0.47594416 0.3884014; 0.30219725 -0.44314498 -0.2536722 0.21926808 0.27753645 -0.3428621 -0.38565582 0.32572436 -0.28490883 -0.35997775 -0.32564154 -0.4343702 0.33074692 0.14081503 -0.17992814 0.54262537 -0.2338441 0.02095217 -0.40039444 -0.40850765 -0.2808587 0.2943197 -0.40410957 -0.31600732 0.26386243 -0.3517208 0.1857177 -0.24006599 0.30648246 0.41102418 -0.5990364 0.18947111 -0.2928503 -0.31903926 0.1121454 -0.40594736 0.1887935 -0.41099223 0.35806242 0.24462232 -0.26571602 0.15516861 -0.47360376 0.25151083 -0.18406565 -0.19516698 -0.26044518 0.23941232 -0.4452832 0.21407965 -0.20778291 -0.28395694 0.41699114 -0.14527881 -0.28140646 0.3020761 0.311326 0.09953281 -0.5457608 -0.3636521 -0.28692645 0.36434186 0.033465065 -0.49609408 0.4372133 0.27322468 0.20673773 0.22833028 -0.26689002 0.39005628 0.33460692 0.27485263 -0.5060214 -0.43544477 0.1456743 -0.1258167 -0.42605782 -0.23954251 0.16483372 0.46893132; 0.5377067 -0.26581717 -0.5674476 0.018637795 0.3446741 -0.466989 -0.4868144 0.2791085 -0.23635246 0.2567519 0.32918087 -0.21774034 0.60252917 -0.19771644 -0.21765217 0.31977195 0.11185385 -0.2802156 -0.3429861 -0.27344182 0.06941283 -0.17595983 0.2370276 0.03243622 0.18685155 -0.5275223 -0.06074622 -0.15192114 0.046619996 0.2749425 -0.5323862 -0.062537886 0.21891616 0.18489084 -0.024360402 -0.46342942 -0.12385264 -0.34179482 0.014235579 0.02469841 0.00727515 -0.11346904 -0.41810563 -0.06219567 0.29532307 -0.4354211 0.23868349 0.37253067 -0.28115472 -0.08024139 -0.28451878 -0.51015526 0.41092432 0.16149122 -0.5316028 0.042147253 0.24666698 -0.090553224 -0.0041245827 0.29821625 0.15749386 0.36909452 -0.19764152 -0.44027534 -0.08749088 0.4520663 0.2893681 -0.017865537 -0.33804125 0.32954192 0.16852395 -0.14623386 -0.20765212 -0.4922374 -0.031780217 -0.020394625 -0.22637758 -0.51831466 0.47759593 0.4950849; 0.19984308 -0.56377745 -0.53580326 0.2380402 0.22217824 -0.5864152 -0.35393137 0.32103086 -0.5036024 -0.32313126 -0.11942283 -0.30415833 0.5382135 -0.007923868 -0.20057622 0.3676879 -0.4036349 -0.0061478866 -0.5182291 -0.46733612 -0.16141872 0.38473672 -0.27488387 -0.17241526 0.35367158 -0.54775107 0.22645853 -0.44007915 0.24092524 0.5490371 -0.46460122 0.14198475 -0.479457 -0.07698144 0.083301276 -0.19738649 0.101030596 -0.36047372 0.09525451 0.23548761 0.017358422 0.19870007 -0.40172973 0.31520593 -0.14604318 -0.3541609 -0.3312576 0.27617124 -0.20864561 0.43102795 -0.52729523 -0.33493316 0.54487425 0.077855885 -0.34824184 0.30703008 0.51970047 0.3727306 -0.33927733 0.012024968 -0.17903078 0.331454 0.039402094 -0.55903286 0.1541675 0.41116428 0.36161563 0.5200337 -0.1663169 0.22610867 0.5839406 0.20046885 -0.5828334 -0.4371051 0.27944124 -0.3180712 -0.25864723 -0.48931924 0.4909054 0.2585069], bias = Float32[-0.09375747; -0.37371308; 0.40466493; 0.40985993; -0.5093617; 0.07838586; -0.09851083; 0.1585697; -0.31866586; -0.40914908; 0.52138543; -0.4243006; -0.20900205; 0.0860792; 0.36478344; 0.13431811; 0.15784365; -0.032691818; 0.29752386; -0.29935554; 0.032438736; 0.37648904; 0.44846055; -0.088808686; -0.3825038; 0.42864046; 0.09461906; 0.36352006; 0.42769423; 0.4730648; 0.002158093; -0.50641847; -0.3510494; -0.052564185; 0.23962048; 0.116739; -0.13756168; 0.425316; -0.037671298; 0.31344694; -0.10605523; 0.33788398; -0.50165623; -0.030119006; -0.3919013; 0.01683492; -0.48612267; 0.29038167; 0.37066647; -0.45871648; -0.2465894; 0.3928511; -0.2563042; -0.3871726; -0.36439645; -0.4260115; 0.32430068; -0.06728904; -0.03865686; -0.5007418; 0.15079948; 0.370217; 0.2419543; -0.028295372; 0.14372371; -0.34533432; -0.41916355; -0.40348995; -0.048895206; 0.1424578; 0.1052095; -0.28565618; -0.23512459; -0.44124076; 0.41473368; -0.42420298; 0.12227798; 0.3075376; -0.14383146; 0.21329711]), layer_3 = (weight = Float32[-0.30936372 0.15831578 0.177811 -0.40095475 0.28308716 0.06932258 0.20196766 -0.31213918 -0.21327256 0.11518328 -0.26347718 -0.040245194 0.42393813 0.3043599 -0.4552478 -0.056422547 -0.42567787 -0.19187166 0.17826319 0.14879327 -0.4128358 0.3122865 0.10470931 -0.041918535 0.6162221 0.26339188 0.08741951 -0.54307324 0.3492862 0.018630344 -0.13064198 0.10273687 0.004152506 -0.18618348 0.017793786 0.26935044 0.0639693 -0.108921 0.09356735 -0.23477638 -0.118798986 -0.29951566 0.2401745 0.43219146 -0.33332694 -0.0014518275 0.36073667 -0.51091903 -0.60689634 -0.026768306 0.4798377 0.27113745 -0.20250179 0.21580632 0.5845955 -0.3771654 -0.5181584 -0.0335488 0.10837014 0.23792607 -0.37720677 -0.55079913 -0.49852815 -0.35307887 -0.023087488 0.5449573 0.15374242 0.47351694 0.43868887 0.34394315 0.26781064 0.49324673 0.19815174 -0.25903058 -0.031105276 -0.13320544 -0.012274029 0.252434 -0.3071949 -0.21382487; -0.06550776 -0.17437035 -0.12881559 -0.097954236 -0.37261614 0.2014552 0.25075334 -0.20596218 -0.06463691 0.5278128 0.379483 -0.40677372 0.48402616 0.38400927 0.043750614 0.18519968 -0.1998923 -0.66521966 0.029278185 -0.1859232 -0.24816938 0.033974398 0.35526913 0.42970377 -0.16152829 -0.10683205 0.5697137 -0.45245627 -0.0698384 0.2835709 0.4524331 -0.29147053 -0.5048142 -0.6280509 0.23315741 0.35447285 0.20775624 0.22471026 0.17236964 0.1356217 -0.6047262 -0.5573686 -0.32124323 0.052570604 0.03495809 -0.39493838 -0.029621325 -0.05229018 -0.08636904 -0.30462703 0.18371946 0.13314326 0.41232666 0.47188774 0.02141737 0.14757462 0.20155545 0.30151933 0.24316068 -0.35371122 0.08049424 -0.090246074 -0.15655798 -0.24449387 -0.2693048 0.37552625 -0.23343319 0.13255098 0.09370603 0.06057564 0.10533684 0.11893421 -0.11166795 -0.014230257 -0.44543225 -0.26529583 0.17161539 0.102074616 -0.15803668 -0.64009506], bias = Float32[-0.4128028; 0.046707526]))



C = 0.01

function whitedwarf(du, u, p, r)
    psi = u[1]
    dpsi = u[2]
    du[1] = dpsi
    du[2] = (-((psi^2-C))^(3/2) - 2/r * dpsi)
end
#Defining the Ordinary differential equation as an ODEProblem with the DifferentialEquations.jl
prob = ODEProblem(whitedwarf, I, etaspan)
#Solving the ODEProblem with the Tsit5() algorithm
sol = solve(prob,saveat=etasteps)


true_data= Array(sol)
### Define loss function as the difference between actual ground truth data and Neural ODE prediction
function loss_neuralode(p)
    pred = predict_neuralode(p)
    loss = sum(abs2, true_data .- pred)   
    return loss, pred
end
loss_neuralode(p)[1]




#--------------------
#High noise recovering of trained loss  
#-----------------------
#------------------
rng = Random.default_rng()
Random.seed!(99)

x1=Array(sol)

x1_mean = mean(x1, dims = 2)
noise_magnitude = 35e-2
x1_noise = x1 .+ (noise_magnitude*x1) .* randn(eltype(x1), size(x1))
#Displaying true data vs noisy data

true_data= x1_noise
p = (layer_1 = (weight = Float32[-0.58095783 -0.8647286; -0.7001862 -0.6357462; -0.44274226 -0.2886219; 0.5826778 0.40713358; 0.5768814 0.39769512; 0.83455765 0.5639017; 0.27206278 0.6918828; -0.2542517 -0.9221925; -0.5260644 -0.5476454; -0.8716557 -0.8656419; 0.79166317 0.6219296; 0.5448242 0.94499946; -0.6392305 -0.6329471; -0.55225694 -0.5951357; 0.7892012 0.6215277; -0.39533776 -0.60611564; 0.37770805 0.36751047; -0.52461016 -0.2973591; -0.5315324 -0.8797248; -0.56268466 -0.5937338; -0.16775154 0.8762929; -0.5910737 -0.67723435; -0.90611064 0.5801994; -0.61688423 -0.44543183; -0.6193237 -0.7394906; -1.1238823 0.28449178; -0.59943324 -0.8230343; -0.52062774 -0.389398; -0.9019579 -0.78362477; -0.23548585 0.2232138; -0.5207952 -0.5210206; -0.91718686 -0.499972; -0.7951948 0.44162914; -0.53997815 -0.28771433; 0.6384278 0.44626892; -0.5702294 -0.4553223; -0.6736018 -0.6175356; -0.6021037 -0.38142985; 0.5724666 0.55448234; -0.58399767 -0.3196869; -0.530272 -0.25060603; -0.5693902 -0.38989562; -0.5966902 -0.86581075; -0.62783027 -0.5307712; 0.52662283 0.53084564; -0.565788 -0.49489227; -0.37799242 -0.75373924; 0.46034753 0.71792126; -0.56517786 -0.46614566; 0.39453852 0.9069079; 0.16869798 0.8596637; 0.6090209 0.5898701; -0.5845049 -0.46910545; -0.534225 -0.57182145; -0.51703423 -0.73239034; -0.796749 -0.83710235; -0.5726243 -0.6084474; 0.49430448 0.8104577; -0.5170827 0.2763302; 0.5299074 0.5590775; -0.42556602 -0.67284745; -0.568442 -0.28502402; -0.63469464 -0.2902196; -0.7008069 -0.5848692; 0.83603495 -0.5087062; 0.5623074 0.47825262; -0.75978416 -0.62850213; -0.68012035 -0.60614794; -0.5382414 -0.57728934; 0.6020159 0.80926985; -0.5038196 -0.3673655; 0.64748096 0.7819176; 0.56525236 0.32241222; 0.6594978 0.66843617; -0.46895522 -0.4982919; -0.654244 -0.574883; 0.9288141 0.75260913; 0.48948154 0.3449771; 0.38406956 0.7384775; 0.62152576 0.8241255], bias = Float32[-0.75563914; -0.6998468; -0.72710705; 0.66349393; 0.67167556; 0.6366331; 0.5452427; -0.55340546; -0.5995729; -0.52420706; 0.67622435; 0.43617898; -0.66609144; -0.67524534; 0.59236485; -0.6441328; 1.0376073; -0.65983254; -0.77088755; -0.638566; -0.5422373; -0.6436069; -0.4561559; -0.6392655; -0.51779234; -0.19261168; -0.59171695; -0.5008864; -0.6282803; -0.5767185; -0.553878; 0.8023187; -0.7000442; -0.6954869; 0.6159925; -0.62782276; -0.60313296; -0.6505059; 0.6262858; -0.63417906; -0.63543826; -0.75757235; -0.52138424; -0.6172175; 0.69868714; -0.6164397; -0.54298913; 0.57719797; -0.6546473; 0.67919236; 0.49083406; 0.5962867; -0.6329187; -0.7209456; -0.6716181; -0.66426885; -0.52025443; 0.7406847; -0.5924771; 0.60900486; -0.7325045; -0.71297663; -0.58356297; -0.4549167; 0.34358507; 0.75460804; -0.6830998; -0.6881013; -0.5251689; 0.6789244; -0.6150959; 0.5362348; 0.53923506; 0.46395254; -0.62650114; -0.56923324; 0.65768844; 0.67229295; 0.7489055; 0.69417405]), layer_2 = (weight = Float32[0.5949014 0.6401624 -0.613549 0.47714677 0.5750596 -0.38996792 -0.75802606 0.50493085 -0.5621505 0.6626246 -0.6088141 -0.5813146 0.48824838 -0.5534686 -0.50972724 -0.4839827 0.51727766 -0.4925457 0.5360085 -0.60973454 -0.43851295 0.48970598 0.4926956 -0.4862251 0.39963612 0.55989903 0.4756555 -0.70111203 0.5751909 0.5355428 -0.47664574 -0.46170804 0.622749 -0.58901054 0.52875113 -0.56484556 0.5037049 -0.7411564 0.5384754 -0.7516913 -0.67215973 -0.579712 0.43494135 -0.43426326 0.47298017 -0.7632232 0.5448758 0.50258327 -0.55624694 -0.71852887 -0.7834376 0.71806157 -0.5716144 -0.6482342 0.69978386 0.59940803 -0.47588775 -0.67865556 0.5673491 0.42521116 -0.72750765 -0.70310444 -0.79461396 0.4614215 -0.5413277 0.5280793 0.62203884 0.4841711 -0.5383253 -0.41016656 -0.6481507 -0.7586665 0.7922661 -0.7291791 -0.6024232 -0.71599036 -0.7045114 0.5533803 0.6225399 -0.49399382; 0.68216556 0.43275595 -0.68777066 0.5747835 0.4693332 -0.40714085 -0.62272465 0.5249284 0.34711266 0.6087713 -0.65355283 -0.57277906 0.61320233 -0.57501644 -0.47692016 -0.54697937 0.7718844 -0.61301583 0.5389169 -0.7579648 -0.40200993 0.65775126 0.554729 -0.6800008 0.38462597 0.4609303 0.55011886 -0.7135128 0.6999574 0.5935431 -0.6540852 -0.6143963 0.6033551 -0.62758005 0.62621915 -0.7440243 0.68422335 -0.7095685 0.5615559 -0.73960745 -0.5379509 -0.45512974 0.38905782 -0.5031011 0.6047624 -0.8179668 0.5963419 0.7843289 -0.6668102 -0.6418862 -0.71620256 0.5900057 -0.46748364 -0.5786343 0.5036919 0.6320699 -0.7976874 -0.7139981 0.43874893 0.69380903 -0.7304034 -0.7020595 -0.7923903 0.6292393 -0.6153625 -0.6534785 0.7154725 0.6524588 -0.47736713 -0.7537013 -0.7154661 -0.5475973 0.6782739 0.56731784 0.632361 -0.6943194 -0.4773847 0.6742431 0.5081552 -0.68443775; -0.5192072 -0.4774172 0.72153896 -0.67860013 -0.62881273 -0.6508708 0.71198034 -0.53666216 0.5479302 -0.3981817 0.5782078 0.5497918 -0.60810006 -0.6828654 -0.70512986 0.6372991 -0.7552703 0.50185066 -0.5392146 -0.7223085 0.5092131 -0.58326113 0.7492646 0.74066734 -0.62615204 -0.4291533 -0.6652397 0.73342633 -0.69846934 -0.4663255 0.50609595 0.55152434 -0.36375228 0.52131987 -0.8409459 0.4954398 0.55930734 0.51186424 0.56775856 0.67003286 0.8256784 0.7497462 -0.4544792 0.5471288 -0.5168549 0.5316348 -0.6647395 0.64325404 0.5176445 0.38360703 0.48625737 0.6521979 0.7688403 -0.7136675 -0.70326996 -0.57716876 0.7111644 0.5767687 -0.47624075 0.53987783 -0.40545374 0.7864473 0.7611064 0.51602626 -0.79521394 -0.67588586 -0.5809245 0.44833437 0.55768603 0.43339813 0.7661106 0.3424305 -0.50804675 0.56250906 0.5307297 0.74728066 0.6513982 -0.75053626 0.5927261 0.70313585; 0.6113225 0.6234133 -0.36159477 0.6790706 0.51198155 -0.33462495 -0.8051248 0.48774332 -0.6450002 0.6087755 -0.84510124 -0.58237606 0.79720896 0.4278281 -0.918377 -0.49331218 0.6077258 -0.5414145 0.6098995 1.4108706 -0.60564584 0.7400762 -0.5102645 -0.6226641 0.57084334 0.5233198 0.75160444 -0.36512896 0.6807553 0.7621255 -0.43048337 -0.7480374 0.8495348 -0.7348333 0.3970497 -0.6306751 1.4778317 -0.512403 -0.020720808 -0.6444698 -0.6382888 -0.46020848 0.48519117 -0.29717097 0.50291264 -0.36938706 0.8007479 -0.6550984 -0.43724298 -0.7031934 -0.5006689 0.19497496 -0.53232586 1.1328154 0.7044269 0.7335585 -0.24218011 -0.62432003 0.5450174 0.4908098 0.6818851 -0.37939978 -0.42466378 -0.24314636 -0.36213115 0.57439816 0.63415444 0.9763089 -0.41237167 -0.80897987 -0.51157707 -0.5398849 0.42988 -0.7146489 -0.51397955 -0.47478265 -0.45705023 0.45835388 -0.7279321 -0.6923145; 0.7832974 0.75895417 -0.673891 0.4589273 0.49469486 -0.60318553 0.49882463 0.6299009 0.5823309 0.6265696 -0.5659339 -0.78568006 0.77853173 -0.5863566 -0.67313206 0.46011633 0.5792631 -0.48914897 0.47759354 -0.6363558 -0.43475527 0.70738286 0.63771135 0.71643925 0.63220364 0.7338055 0.7122308 -0.7036163 0.77335805 0.580405 -0.6920821 -0.546828 0.6648514 -0.55260164 0.45981085 -0.56706196 0.55483913 -0.54307336 0.4076072 -0.55065227 -0.596381 -0.5293361 0.45664623 -0.6385981 0.64232016 -0.7316013 0.71494 0.6754745 0.61443484 -0.63904935 0.934434 0.41622177 -0.46848622 -0.5269852 0.57749647 0.7940282 -0.56290966 -0.43859872 0.3797206 0.52609926 -0.7391518 -0.45223567 -0.6139222 0.68855697 -0.6121111 -0.6228122 0.77927464 0.41345116 -0.52512646 -0.69840074 -0.54704505 -0.58947104 0.7095214 0.7600566 0.65724707 -0.57498103 -0.682932 0.57576996 0.61008716 -0.43463013; -0.39399263 -0.6629623 0.44734496 -0.50302 -0.7343953 0.714753 0.7633571 -0.547486 0.8255052 -0.52042145 0.66351444 0.7084918 -0.61532915 0.54814243 0.6471684 0.69340193 -0.5612282 0.6138796 -0.3913383 0.43228686 0.7731234 -0.62877035 -0.7222686 0.6884056 -0.58785594 -0.7772521 -0.7340917 0.42064416 -0.40607375 -0.43388125 0.52565277 0.6439806 -0.53740513 0.73465174 -0.78972995 0.75474304 -0.7439126 0.44860688 -0.67035913 0.75446373 0.6065514 0.66850126 -0.67881364 0.5251009 -0.544716 0.45225284 -0.513304 -0.5481282 0.705358 0.7338863 0.45470294 -0.7780542 0.54254234 0.6600348 -0.5573057 -0.41419196 0.44216105 0.6208937 -0.7644761 -0.48250338 0.4607423 0.5215805 0.58683413 -0.4371138 0.5223499 -0.59395355 -0.4286464 -0.37257835 0.6010241 0.46313858 0.46153456 0.4190469 -0.4962669 0.4633241 0.5853806 0.70213056 0.73990667 -0.68552256 -0.7017817 0.6034058; 0.58931905 0.46867537 -0.5863785 0.4551121 0.44937065 -0.7653207 -0.5448218 0.6064489 -0.3951682 0.72841066 -0.49097788 -0.7258038 0.4721351 -0.5631909 -0.621357 -0.77477676 0.47897923 -0.64763904 0.63949203 -0.57055885 -0.54607326 0.77491677 0.6525302 -0.54961705 0.6694206 0.8422448 0.43143916 -0.50089437 0.67896277 0.5118481 -0.71144545 -0.5583587 0.43578327 -0.6815704 0.4637122 -0.6474384 0.7699645 -0.57697827 0.53935534 -0.41248125 -0.41652602 -0.62994933 0.66115373 -0.47151354 0.5983422 -0.683149 0.5176172 0.36596984 -0.50236946 -0.6031802 -0.60628945 0.70338637 -0.50774395 -0.7395608 0.50937986 0.4494608 -0.58024246 -0.38809836 0.5727096 0.650521 -0.72151154 -0.4344287 -0.6769248 0.57023066 -0.9309383 0.49465543 0.4862766 0.7478881 -0.47363687 -0.76282364 -0.7879667 -0.46707383 0.6243023 -0.80659074 -0.38325423 -0.4410436 -0.7471477 0.6363255 0.6127827 -0.71915096; 0.5910484 0.4565946 -0.61232394 0.59764767 0.5644996 -0.6795998 -0.77490133 0.64685714 -0.6250473 0.47882873 -0.7876293 -0.7277784 0.55911285 -0.4771099 -0.6946869 -0.40594694 0.4155 -0.41192552 0.5071219 -0.3723518 -0.4129741 0.5662352 1.1066607 -0.4045507 0.48425132 0.57943577 0.68308914 -0.6235565 0.4421313 0.57024795 -0.7209303 -0.49513283 0.8220187 -0.7508229 0.5804656 -0.43656802 0.87283117 -0.764512 0.57986414 -0.61675096 -0.41040838 -0.71335614 0.6387276 -0.37138313 0.5139521 -0.38513243 0.4942759 -0.9105457 -0.42748982 -0.76287466 -0.7489135 0.41417477 -0.39850402 -0.35504174 0.73597616 0.571999 -0.29998222 -0.6982303 0.5625243 0.5747556 -0.6777941 -0.6591394 -0.6987002 1.0794111 -1.178394 0.3969652 0.47931868 0.6661566 -0.524691 -0.51640904 -0.650893 -0.42518115 0.43247214 -0.57140344 -0.3688379 -0.6337514 -0.55932844 0.46096534 -1.0304625 -0.5903413; -0.6818709 -0.6135219 0.57088906 -0.5054392 -0.7054806 0.7574883 0.5784275 -0.6174888 -0.71942717 -0.5964062 0.6604059 0.5638434 -0.6683368 0.43407175 0.4620283 0.66253734 -0.5478841 0.5806071 -0.48261276 0.48788092 0.45265675 -0.59183615 -0.57732105 0.596813 -0.69454426 -0.57795864 -0.42964977 0.771473 -0.47228107 -0.5032725 0.41896713 0.4466156 -0.79901457 0.45896697 -0.43493763 0.4897181 -0.4998656 0.69521964 -0.43936107 0.68984544 0.5443711 0.77426535 -0.5880511 0.6255072 -0.71539104 0.46967793 -0.433014 -0.51636046 0.64062095 0.56132126 0.6882388 -0.49842146 0.6785564 0.5024068 -0.6454558 -0.7482293 0.42477164 0.5821985 -0.5727947 -0.6984603 0.48843607 0.59191084 0.52116734 -0.53085876 0.6871167 0.7315189 -0.4610359 -0.4322172 0.62931406 0.5180811 0.62355584 0.7766836 -0.66180825 0.5304746 -0.7498944 0.66569585 0.6405239 -0.7794455 -0.6318535 0.621385; -0.54532564 -0.6062503 0.7134666 -0.5991988 -0.5517006 0.7807769 0.09979967 -0.76393795 -0.4478097 -0.6198936 0.70791584 0.5626485 -0.5651776 0.5119555 0.45661467 0.5648363 -0.74092937 0.53067994 -0.49001876 0.5316432 0.40584877 -0.73024327 -0.7182671 0.44456643 -0.58497226 -0.8715907 -0.44941843 0.5584772 -0.7218677 -0.8111053 0.70792013 0.315335 -0.813336 0.4372279 -0.38414374 0.54312885 -0.600869 0.53676254 -0.5325682 0.46166146 0.7084577 0.55912673 -0.54052526 0.49893805 -0.60765964 0.64618486 -0.7214456 -0.5463137 0.55932593 0.5262489 0.44061115 -0.38927263 0.48261043 0.58790517 -0.45770222 -0.72112846 0.56209356 0.5698174 -0.46629664 -0.7414603 0.7169409 0.45790434 0.38364083 -0.6210097 0.75814533 0.6404136 -0.6489628 -0.59503716 0.62348354 0.78240037 0.45258176 0.45787913 -0.47490343 -0.7051161 -0.61734897 0.5156921 0.8178717 -0.74898237 -0.67143416 0.53219664; 0.45511392 0.6210499 -0.4962516 0.6626392 0.41617343 -0.63895506 -0.68692315 0.50457823 0.94243664 0.44286615 -0.6505608 -0.42885596 0.75185674 -0.62119496 -0.64525884 -0.34915236 0.7226132 -0.46882993 0.4739329 -0.5650145 -0.58593994 0.74927974 0.5992946 -0.43048495 0.64386266 0.4746113 0.44353467 -0.69807625 0.5824696 0.5061228 -0.42640045 -0.5485636 0.79563206 -0.5040302 0.5250776 -0.45940304 0.59096336 -0.55079556 0.5069126 -0.48627928 -0.64170045 -0.70508164 0.75518364 -0.55883366 0.49138203 -0.42615268 0.44722763 0.41584817 -0.52391577 -0.53108114 -0.6903689 0.6000448 -0.5491231 -0.7488004 0.76951665 0.6968183 -0.5324003 -0.6089924 0.6842425 0.52828044 -0.6991311 -0.49758217 -0.49258047 0.81246555 -0.7216781 -0.9368084 0.62055945 0.6852972 -0.59002787 -0.7610577 -0.59059507 -0.42196953 0.66288644 -1.0368725 0.55228657 -0.5640074 -0.63490915 0.5941454 0.5694536 -0.42417136; 0.69973826 0.45047206 -0.7629397 0.5861063 0.5475647 -0.7153727 -0.7395618 0.55223835 -0.58101135 0.42810443 -0.6397349 -0.54846686 0.52870035 -0.4933474 -0.7585972 -0.66905904 0.7618164 -0.52762216 0.5955354 -0.5805478 -0.7062651 0.5125117 0.6391802 -0.6856763 0.5526827 0.44084516 0.6932614 -0.8171416 0.5500065 0.5848494 -0.48706535 -0.54364675 0.5112989 -0.7767013 0.6485938 -0.55306137 0.5390517 -0.5870408 0.43973655 -0.7006422 -0.5215551 -0.72156566 0.52203953 -0.50349253 0.5598983 -0.4739344 0.5831704 0.75082415 -0.5644303 -0.6223713 -0.7919987 0.46754336 -0.4618979 -0.708857 0.75212085 0.53774554 -0.75840193 -0.5855447 0.6083271 0.43210778 -0.6564044 -0.6368203 -0.8139587 0.52636784 -0.44773194 0.42221117 0.47633955 0.6832132 -0.4555634 -0.46233797 -0.4538567 -0.6301441 0.5841373 -0.7777159 0.7007654 -0.7354691 -0.731929 0.67837375 0.6847821 -0.5418897; -0.51987416 -0.41510165 0.6100997 -0.59453595 -0.464755 0.57881033 0.4441322 -0.64887905 -0.3556395 -0.73149675 0.48579302 0.5313928 -0.7734051 0.5948757 0.52371573 0.61901325 -0.6791522 0.5141115 -0.5670708 0.6108033 0.7269409 -0.56604743 -0.4689972 0.7473533 -0.60047984 -0.4773654 -0.60431385 0.779347 -0.5572722 -0.7361034 0.72213924 0.6080153 -0.4514074 0.6682237 -0.6670541 0.54757935 -0.65992767 0.64870137 -0.62633157 0.5026978 0.4343543 0.7450488 -0.4513941 0.65073836 -0.41044992 0.7312942 -0.49780878 -0.7553999 0.42625403 0.5553028 0.69501364 -0.68730503 0.4408867 0.44489163 -0.4892189 -0.76190275 0.76303434 0.69983286 -0.56470525 -0.62606865 0.7003826 0.54696417 0.50173914 -0.50545627 0.5899775 0.6528782 -0.53043175 -0.77702045 0.5606924 0.79465836 0.5875629 0.60470814 -0.42689267 -0.5310848 -0.63962156 0.5027094 0.7098694 -0.6038513 -0.4758258 0.5565514; -0.81192464 -0.70980316 0.46234235 -0.38831943 -0.7028003 0.79943645 0.496709 -0.56200194 -0.6002295 -0.49215043 0.6601211 0.7499893 -0.8135206 0.5811204 0.72561264 0.4541888 -0.66447735 0.73149985 -0.75875413 0.47126985 0.6911619 -0.51601434 -0.75240797 0.65355754 -0.50520676 -0.7377032 -0.53398335 0.6986377 -0.7331831 -0.6558602 0.62687886 0.74911165 -0.47934833 0.7318604 -0.56438035 0.7674063 -0.57240057 0.49623594 -0.7535436 0.59763587 0.68361074 0.66487277 -0.6675115 0.49502376 -0.51475304 0.40280852 -0.48560798 -0.55406165 0.67682165 0.5038636 0.81460726 -0.629331 0.41639414 0.61701405 -0.48628047 -0.67660034 0.62384206 0.70294815 -0.72881085 -0.7475281 0.592835 0.6059814 0.68482804 -0.75433487 0.45686424 0.58709383 -0.6470109 -0.7810683 0.6788844 0.74087024 0.7031979 0.50491184 -0.52913874 0.38506427 -0.7502845 0.6149495 0.74391776 -0.55307263 -0.5836873 0.45950153; 0.48651156 0.49456653 -0.70456773 0.5999074 0.5062424 -0.5315517 -0.50849366 0.6232321 0.59513897 0.4198872 -0.6463219 -0.4516298 0.54919213 -0.56838906 -0.43050754 -0.5769262 0.46602616 -0.5034316 0.6786294 -0.5723416 -0.57655984 0.7545542 0.72655535 -0.45565638 0.6659588 0.7733529 0.5447781 -0.62623876 0.5194082 0.734401 -0.4638399 -0.589648 0.6151321 -0.5830729 0.61278826 -0.5818715 0.66146743 -0.5513154 0.56314474 -0.80066246 -0.5713785 -0.79947335 0.646356 -0.74609965 0.511336 -0.5263713 0.52397305 0.41681337 -0.49407396 -0.5280841 -0.6877104 0.48270395 -0.76768965 -0.6672302 0.68310696 0.5901787 -0.49120086 -0.48730057 0.5238908 0.47902766 -0.6456823 -0.5173959 -0.4648139 0.6080759 -0.6135312 -0.43252876 0.48346925 0.7014388 -0.509639 -0.52615476 -0.52495354 -0.40017217 0.5048354 0.5814683 0.68984723 -0.6055737 -0.7300613 0.439793 0.7011437 -0.5845817; -0.6457411 -0.40970725 0.51874065 -0.47158873 -0.7141261 0.6259728 0.78668946 -0.51221 0.6112941 -0.75955856 0.49601036 0.7355453 -0.7409405 0.41503596 0.7499669 0.56819856 -0.76839614 0.4126974 -0.41406187 0.55795205 0.59851915 -0.7726875 0.7128541 0.41608572 -0.71828717 -0.41748685 -0.5744932 0.43886113 -0.61400837 -0.5412684 0.7579472 0.548784 -0.5848382 0.74517834 -0.7030519 0.7243717 -0.6778317 0.6111758 -0.3850668 0.60619354 0.4766628 0.62152684 -0.5744263 0.6987306 -0.64024794 0.71150976 -0.4971221 0.766558 0.7708409 0.56691307 0.76540774 -0.6444147 0.7666194 0.73760664 -0.72678983 -0.659278 0.7572027 0.5953022 -0.46329814 -0.61319387 0.23119411 0.6208738 0.45194417 0.62315875 -0.21377769 -0.60678744 -0.55082804 -0.50241613 0.6038579 0.52820855 0.7641167 0.62379724 -0.70157707 0.47737643 0.6900138 0.4826431 0.4238297 -0.65236926 0.4912698 0.4148259; -0.46555093 -0.730933 0.5115436 -0.54719985 -0.4273027 0.53048575 0.6528023 -0.80513006 -0.6346829 -0.43323666 0.6100885 0.7448854 -0.8248034 0.5854028 0.59833074 0.46748102 -0.44367102 0.44765383 -0.42507634 0.60405016 0.41154608 -0.47140014 -0.6667019 0.42636168 -0.4812243 -0.5156284 -0.5098517 0.50780576 -0.44097728 -0.68645406 0.4866594 0.73285615 -0.7481877 0.39992163 -0.43421116 0.41799182 -0.46752265 0.6921375 -0.5645456 0.64228284 0.62393045 0.7611746 -0.7047994 0.7683931 -0.4314732 0.58220553 -0.5250701 -0.44538748 0.39910385 0.56333655 0.64844525 -0.6773932 0.43911448 0.5033015 -0.6607866 -0.54240495 0.6775299 0.48747772 -0.67867845 -0.40250853 0.71607566 0.44695377 0.7776671 -0.7617683 0.64280623 0.76958346 -0.46706358 -0.71512264 0.47543326 0.66658044 0.5450148 0.6070627 -0.6717374 1.2722194 -0.8249413 0.70324546 0.60303605 -0.61766946 -0.42478597 0.47581676; -0.640024 -0.58012134 0.57671916 -0.7586845 -0.50027806 0.50819147 -0.75679725 -0.7114226 -0.36580455 -0.55408555 0.59955335 0.48058927 -0.56197584 0.56853753 0.42495576 -0.4843135 -0.5291407 0.5063443 -0.5835989 0.5884939 0.459095 -0.4746789 -0.5645898 0.82018393 -0.53540313 -0.651101 -0.4643504 0.4942119 -0.395903 -0.5761972 0.47140846 0.7516074 -0.77488613 0.6306023 -0.7872408 0.6961872 -0.44569463 0.5931161 -0.5857552 0.58611757 0.5382535 0.64765614 -0.6846145 0.7924872 -0.522775 0.5988871 -0.53595185 -0.7354096 0.6227939 0.36632708 0.48890573 -0.7164877 0.5453146 0.6429526 -0.5263829 -0.38393027 0.5463816 0.36582962 -0.58692193 -0.7625192 0.62906027 0.6033347 0.51730454 -0.4612418 0.5430178 0.55452806 -0.71553224 -0.42139196 0.5417801 0.7499232 0.667795 0.46260855 -0.5029528 -0.65549654 -0.37504914 0.6600093 0.54795706 -0.5360793 -0.71086925 0.43937412; -0.7551003 -0.7718689 0.6007624 -0.68332356 -0.6009983 1.0008295 0.67804533 -0.76503164 0.33501273 -0.46193153 0.7107506 0.5434662 -0.77158433 0.5415158 0.5449437 0.49982086 -0.56950396 0.49669382 -0.4997213 0.23087163 0.6315087 -0.46839195 0.589367 0.555348 -0.5165914 -0.5957783 -0.7470154 0.73734033 -0.7366113 -0.663681 0.5056516 0.47584802 -0.77273273 0.76234615 -0.42507777 0.56890076 -0.6847066 0.5520593 -0.31614903 0.6861012 0.6154567 0.47617966 -0.6727488 0.3936848 -0.61989194 0.7238325 -0.4640908 0.8297563 0.4952624 0.56170434 0.53443134 -0.2996185 0.517743 0.1148308 -0.47956496 -0.5876354 0.38832176 0.45715454 -0.73012704 -0.66806954 -0.8455045 0.433706 0.5812547 0.5720148 -0.47834665 -0.7323911 -0.5296955 -0.73217314 0.7068767 0.75454825 0.59586227 0.8176932 -0.6264282 0.7007399 0.35419035 0.55036086 0.78286254 -0.48697716 0.5788641 0.6101594; 0.44777367 0.76948965 0.8064553 -0.65625423 -0.6061355 0.5755379 -0.47992346 0.719218 -0.4258811 -0.65186656 0.77677286 0.3507489 0.64208674 0.4924567 0.47438616 -0.5130477 -0.7275289 0.47292444 0.70585394 0.6714815 0.4794344 0.69850504 -0.74627376 -0.467064 -0.5113576 -0.7281591 0.64284885 -0.76257765 -0.576774 0.7988707 -0.6319998 -0.45255178 0.32788748 0.44070065 -0.53456146 -0.6130831 -0.58223724 -0.6275689 -0.7840461 0.5355918 0.7140075 0.7497751 -0.50405914 0.71980524 -0.6911674 0.92766356 0.66360635 -0.5260897 -0.5329092 -0.4348311 -0.6052808 -0.6267071 0.48183155 0.5354465 0.78580576 -0.54972315 -0.4539566 -0.7948229 0.5343938 -0.5846304 0.46657425 0.81253713 0.56955284 -0.7210125 0.6114373 0.44866687 -0.39330652 -0.39490202 -0.47485438 0.29054582 0.6387952 0.44830337 0.7417336 -0.63532346 -0.74160135 0.57721615 0.593141 -0.78223395 -0.6376327 0.659671; -0.33719552 -0.40049744 0.5117003 -0.6141987 -0.49722415 0.5554615 -0.6216926 -0.595361 -0.58081394 -0.32767206 0.3644822 0.55289805 -0.50004745 0.61690485 0.3282609 -0.28042737 -0.6875815 0.5699958 -0.5007308 0.6246299 0.6532212 -0.33052126 -0.6580006 0.73344344 -0.57670236 -0.4812734 -0.7073884 0.49870715 -0.5081767 -0.6862137 0.77620524 0.6148013 -0.37078908 0.56593615 -0.82559234 0.72873884 -0.7028373 0.5450536 -0.63091254 0.7803484 0.7588496 0.5538866 -0.4084118 0.60771275 -0.6059368 0.6160859 -0.53873646 -0.7286434 0.908629 0.6269136 0.46508437 -0.8262705 0.5308018 0.7957613 -0.4432651 -0.5780157 0.820574 0.4900283 -0.32110748 -0.65388584 0.7969812 0.77288705 0.51724154 -0.47143573 0.6112561 0.5553987 -0.33702627 -0.64061624 0.706716 0.3735505 0.83679134 0.4817094 -0.75895464 -0.51194054 -0.6258376 0.6009897 0.5510204 -0.8458213 -0.608108 0.5546845; -0.5021462 -0.5922946 0.7629743 -0.6260273 -0.5950204 0.4379734 0.61915636 -0.40964553 -0.6869641 -0.48686847 0.52943027 0.6470119 -0.6501524 0.51456463 0.7152529 0.68105614 -0.7102594 0.733884 -0.36333102 0.46957415 0.6439086 -0.50954056 -0.4957114 0.48463824 -0.7157084 -0.7541292 -0.6903813 0.59762573 -0.7253382 -0.6860844 0.70859414 0.13880199 -0.38847542 0.7182472 -0.47481713 0.76291317 -0.63084763 0.5942195 -0.5023986 0.7840808 0.47138396 0.48682868 -0.66402686 0.5593733 -0.62613106 0.7819403 -0.5552644 -0.43098053 0.8237958 0.60813177 0.5275406 -0.48713124 0.684473 0.61061704 -0.5396257 -0.63962317 0.5440528 0.4630918 -0.5610679 -0.48970664 0.6715497 0.6517788 0.43691358 -0.7478879 0.4824845 0.4890143 -0.6403845 -0.37161806 0.5813886 0.61791754 0.78665435 0.737607 -0.806863 0.48211285 -0.49078757 0.5870205 0.62246275 -0.69587284 -0.5609326 0.5084907; -0.677932 -0.64452696 -0.65748775 0.783138 0.6943783 -0.41739988 0.6596578 -0.638877 0.50270313 0.685538 -0.6923385 -0.3340324 -0.708433 -0.67620933 -0.4543345 0.66634786 0.6271376 -0.63662374 -0.40123007 -0.7008975 -0.58076626 -0.5627074 0.6308961 0.37405285 0.47740337 0.47738972 -0.69398916 0.625138 0.6122093 -0.8282304 0.4280025 0.4847802 -0.8402675 -0.8833168 0.6452809 0.6156428 0.6701741 0.47548312 0.5095912 -0.71520174 -0.6456013 -0.7632202 0.58680546 -0.5289088 0.8503849 0.0040552393 -0.6262099 0.5264274 0.69003147 0.57965773 0.77397394 0.6794827 -0.57636297 -0.6319339 -0.7768356 0.55401224 0.35519296 0.6051266 -0.75358415 0.56650877 -0.6020055 -0.76758444 -0.6438524 0.6720816 -0.59106535 -0.5620607 0.42376417 0.3222047 0.34582177 -0.09695523 -0.5405305 -0.4900735 -0.6543736 0.7776418 0.64004844 -0.6631112 -0.47967517 0.52705175 0.7288541 -0.6895518; 0.5321932 0.734982 -0.5112942 0.43416628 0.7036353 -0.5709903 -0.7367484 0.6716462 0.6878042 0.79387206 -0.7403842 -0.51747984 0.64586395 -0.7640066 -0.4526096 -0.41316676 0.5053434 -0.46456042 0.58754534 -0.4307084 -0.7269522 0.4560997 0.5096399 -0.7684175 0.4409539 0.7174547 0.7732111 -0.68230796 0.64207727 0.43699208 -0.6848182 -0.42839167 0.68458587 -0.43824127 0.4580857 -0.7157189 0.6613527 -0.7766622 0.56808877 -0.5719183 -0.4568447 -0.63778436 0.60854393 -0.65492964 0.6319285 -0.48534775 0.7189984 0.408604 -0.7558723 -0.6077722 -0.5478561 0.41461563 -0.5076113 -0.4232082 0.59938383 0.684054 -0.66940504 -0.7154256 0.73866177 0.41818425 -0.42716065 -0.41480437 -0.47379786 0.6453058 -0.58192015 -0.6533802 0.41404876 0.5282366 -0.64183635 -0.75935334 -0.75628364 -0.71273994 0.67975277 -0.6605407 0.51879364 -0.58788985 -0.7075229 0.5145191 0.7388395 -0.51182514; 0.66905004 0.49119148 -0.50278014 0.5936632 0.62478304 -0.748534 0.7971753 0.49112034 0.4563002 0.76863605 -0.7104122 -0.6592465 0.60963494 -0.70203817 -0.60071236 0.5098521 0.4294664 -0.5922036 0.59542865 -0.74486524 -0.5046963 0.7717032 0.6216801 -0.4478517 0.4718304 0.7854545 0.7679795 -0.6372444 0.49926037 0.7057378 -0.53006095 -0.61332875 0.5656434 -0.47683755 0.5152768 -0.60115504 0.72401047 -0.59612614 0.5053298 -0.55930245 -0.6567188 -0.76286197 0.75428855 -0.67917645 0.67877823 -0.7603355 0.70913255 0.50935495 -0.43036443 -0.42972898 -0.49534202 0.6671074 -0.48123223 -0.5946371 0.6959521 0.80132145 -0.47200033 -0.7162316 0.48937708 0.7561264 -0.5552455 -0.4324763 -0.54872113 0.7313831 -0.56035006 -0.6470426 0.46692494 0.42741212 -0.68898934 -0.4894526 -0.41207865 -0.65186423 0.4207377 0.69900036 0.49031118 -0.47098887 -0.44507217 0.67388004 0.51587003 -0.47388744; 0.7561244 0.7549162 0.8051208 -0.6344614 -0.4929816 0.636782 -0.56027174 0.6780345 -0.6295521 -0.41841143 0.49071229 -0.57105815 0.5861556 0.5519771 0.38931414 -0.6744548 -0.65963346 0.7479499 0.64410657 0.57895905 0.5148576 0.65485954 -0.7210501 -0.63373345 0.8415664 -0.7279293 0.7626133 -0.75271696 -0.6318066 0.6036284 -0.48233822 -0.7187865 0.7181565 0.6911626 -0.7106906 -0.41962892 -0.44991237 -0.5289951 -0.8098067 -0.63969624 0.50033957 0.47426853 0.6022972 0.8166347 -0.5701527 -0.49987945 0.6907093 -0.706447 -0.6856161 -0.7348875 -0.5078676 -0.7034364 0.59654284 0.7598271 0.6409393 -0.4110965 -0.16255254 -0.7923186 0.49784943 -0.4560222 0.7745631 0.60280675 -0.4261175 -0.67255145 0.43673572 0.59105784 -0.6754999 -0.45294487 -0.4101754 -0.83344394 0.8079105 -0.69160324 0.5132035 -0.5428488 -0.55804425 0.89481497 0.42627767 -0.48937237 -0.82137674 -0.87357956; -0.49541253 -0.49127626 0.7929803 -0.8116443 -0.801419 0.62043923 0.61370224 -0.49106422 -0.43362248 -0.6442243 0.5650451 0.5454965 -0.5526796 0.6266314 0.4781745 0.573363 -0.58516 0.812661 -0.483389 0.5102912 0.67106587 -0.49365562 -0.5292025 0.69466877 -0.4531799 -0.7515407 -0.58097637 0.8029051 -0.6232849 -0.61791193 0.7137194 0.8204883 -0.5961369 0.5817582 -0.57038146 0.71577173 -0.50523496 0.49616107 -0.4735212 0.58333963 0.46855277 0.6428885 -0.41426584 0.4393026 -0.43938708 0.66639084 -0.4977038 -0.59726214 0.56466144 0.6222054 0.73956937 -0.58118516 0.49314192 0.44269884 -0.6135183 -0.53145856 0.76656693 0.49676338 -0.63695407 -0.44667915 0.4916649 0.48770422 0.5199968 -0.64367205 0.7423209 0.50470936 -0.48976484 -0.42277566 0.6353592 0.55977327 0.6505545 0.47214577 -0.59224313 -0.5344461 -0.46721026 0.6627928 0.5922014 -0.49726915 -0.78868794 0.7339171; -0.6957667 -0.8283994 0.5424503 -0.53287953 -0.54915017 0.47024947 0.7384263 -0.75438136 -0.64702874 -0.65107286 0.60914654 0.5608756 -0.53445554 0.42904434 0.69914067 0.5722842 -0.68419737 0.69201374 -0.7877358 0.38484997 0.49558055 -0.60325044 -0.77070886 0.549323 -0.5237829 -0.4264102 -0.53518635 0.7291474 -0.5579837 -0.59172595 0.7033038 0.50918835 -0.47857004 0.6782371 -0.4567735 0.51814544 -0.52473664 0.6651383 -0.6600861 0.68351996 0.7220227 0.52724946 -0.8098728 0.7241071 -0.47098437 0.45630896 -0.68205035 -0.37924227 0.48380327 0.78002554 0.81198317 -0.50085205 0.64283466 0.38416994 -0.61290896 -0.72291017 0.6586807 0.7146134 -0.50313026 -0.5556635 0.65128505 0.6192887 0.74307984 -0.7899078 0.6000571 0.5368159 -0.4672307 -0.7703615 0.35517046 0.6807774 0.5710753 0.6490274 -0.63405323 -0.48506138 -0.5505398 0.6197502 0.74183005 -0.47825694 -0.71091884 0.5069271; -0.7562765 -0.5831146 0.54576045 -0.658068 -0.76386833 0.48681012 -0.65878594 0.7526304 -0.6440866 -0.45304534 0.7480922 0.45584205 -0.7531092 0.55799866 0.77718794 -0.6065149 -0.5111629 0.5217659 -0.52505195 0.6752151 0.67416215 -0.7799653 -0.5296899 -0.52477115 -0.47293445 -0.6379517 -0.4434591 -0.42222375 -0.6567207 -0.61375415 0.43680018 -0.6312355 -0.719937 0.39071196 -0.5141558 -0.47315493 -0.80681205 -0.7859003 -0.3926427 0.4400066 0.67548245 0.7133465 -0.761154 0.7055707 -0.5434998 0.66716063 0.6669035 -0.6683942 -0.7140492 0.76259804 -0.46157193 -0.48143607 0.46455517 0.6065984 -0.7240547 -0.72170794 0.59263885 0.6541564 0.5152746 -0.47918978 0.76000494 0.5947977 0.4527668 -0.71663254 0.50280195 0.54954046 -0.79826254 -0.5077904 0.5985487 0.77173376 0.42218027 0.7055861 -0.7651725 -0.6146258 -0.6541203 0.4486395 0.59860533 -0.38898322 -0.4315438 0.5766451; 0.4838932 0.65431577 0.7530252 -0.678734 -0.60013497 0.43846646 -0.4787797 0.823199 -0.6890785 -0.4510656 0.44558617 -0.7708727 0.7083032 0.5882152 0.7243783 -0.5675761 -0.816445 0.5456106 0.7233773 0.52632755 0.58585 0.63014114 -0.5342848 -0.7366733 0.946761 -0.41561642 0.7398541 -0.5151072 -0.5520758 0.48820105 -0.6725089 -0.46921223 0.8614355 0.44354966 -0.7101542 -0.70251775 -0.5487945 -0.4026016 -0.6495341 0.14991139 0.52140194 0.63372946 -0.5708217 0.80917674 -0.75585276 -0.16713446 0.80687606 -0.6342219 -0.47277093 -0.56841177 -0.6107269 -0.52516735 0.6665675 0.78197247 0.6799847 -0.5636821 -0.10040638 -0.79698557 0.7961233 -0.4376867 0.6192229 0.6770826 -0.01175068 -0.7087016 0.56851375 0.72493696 -0.6429982 -0.58040607 -0.37901226 -0.8147881 0.6523284 0.41387224 0.48059952 -0.72696245 -0.638111 1.0355005 0.4609962 -0.70980656 -0.7977377 0.34567496; 0.7319386 0.52472514 -0.48934275 0.76577353 0.48162383 -0.6416136 0.6688043 0.7743776 0.76509124 0.61131227 -0.53882724 -0.45829874 0.7669196 -0.6026138 -0.7798255 0.51295716 0.4916135 -0.5946155 0.6914759 -0.6154548 -0.40718555 0.48167986 0.4847718 -0.032992646 0.69705003 0.7005799 0.59747237 -0.7022083 0.76393956 0.5647421 -0.64598286 -0.5036605 0.57993954 -0.42450753 0.7568351 -0.4602362 0.47953913 -0.61057454 0.68762976 -0.40620977 -0.7503929 -0.5951153 0.79539216 -0.43675652 0.4768237 -0.6932371 0.78754854 0.6254087 0.5734989 -0.59111357 -0.48479646 0.4909633 -0.50429076 -0.45541605 0.48241514 0.44466332 -0.71148807 -0.76387495 0.92228794 0.7750641 -0.78805953 -0.4576074 -0.5104785 0.4808844 -0.63922316 -0.5815488 0.529652 0.5090801 -0.49979442 -0.55781686 -0.41060242 -0.44669658 0.39787614 0.771027 0.7592006 -0.43383655 -0.648191 0.5348181 0.5229322 -0.7598452; -0.62713444 -0.783857 0.4453082 -0.44002783 -0.39936134 0.71736765 -0.55229414 -0.37600425 -0.4632523 -0.5627997 0.6923075 0.7098054 -0.6435163 0.6147125 0.7322424 -0.5492324 -0.6579804 0.45929667 -0.46302062 0.4166826 0.49585658 -0.6148609 -0.6057344 -0.69412297 -0.7948937 -0.7407827 -0.5599491 0.52556723 -0.59855324 -0.4577051 0.5432592 -0.4752783 -0.74414235 0.5689085 -0.75252366 -0.6674502 -0.63519216 -0.67304415 -0.76087445 0.4025957 0.72637415 0.6506778 -0.56184906 0.55223465 -0.6397251 0.6500286 0.7158758 -0.75298226 -0.7773604 0.4354114 -0.41099513 -0.7707911 0.45113978 0.72903985 -0.5520506 -0.7505734 0.58474547 0.47989142 0.43174472 -0.62406343 0.5071958 0.59041053 0.46774462 -0.56082326 0.71398515 0.7008082 -0.8112463 -0.6021197 0.5836491 0.61329454 0.41231224 0.53294736 -0.7602894 -0.62391734 -0.48890308 0.65715677 0.7716929 -0.7057268 -0.3897961 0.5669862; -0.48422268 -0.63062525 0.4209626 -0.7064947 -0.5190024 0.7878193 0.5378758 -0.71389824 -0.51215124 -0.66741085 0.6296511 0.47256202 -0.49791592 0.6349013 0.65688825 0.7952844 -0.7125237 0.65183127 -0.5365452 0.7288847 0.682342 -0.6786215 -0.69748896 0.41534087 -0.50517416 -0.80879796 -0.55664575 0.5858997 -0.74761 -0.62087166 0.44315287 0.5258989 -0.7754245 0.44594184 -0.59480405 0.67199045 -0.5952178 0.4907811 -0.65492785 0.57674545 0.39261886 0.5224982 -0.8011506 0.6522875 -0.39186656 0.759168 -0.46962005 -0.42636472 0.69907814 0.76704806 0.71868545 -0.5100382 0.47264895 0.4770131 -0.5106039 -0.5586531 0.47113666 0.6461437 -0.4798107 -0.51690435 0.5059977 0.6233619 0.41287288 -0.63287395 0.30583793 0.36090416 -0.66241574 -0.64933056 0.48437417 0.7433687 0.65895575 0.47877875 -0.48081413 0.34784222 -0.46797213 0.70425856 0.75317043 -0.7214875 -0.47159868 0.7688817; 0.8339046 0.501772 -0.7304883 0.4803563 0.52793163 -0.7636628 0.4623702 0.5071706 0.44838712 0.7550247 -0.81052476 -0.81175524 0.761473 -0.4885788 -0.6465836 0.6435524 0.7076783 -0.6721479 0.544766 -0.7562217 -0.62530017 0.69266146 0.73963517 0.44083792 0.4388879 0.79113233 0.66213286 -0.39763513 0.5798739 0.587939 -0.3881624 1.3034524 0.50643164 -0.6524211 0.6880188 0.28917274 0.8010483 0.14751725 0.5109314 -0.70983744 -0.64533985 -0.5435742 0.5578982 -0.6170136 0.74514854 -0.66692144 0.18040337 0.48258156 0.44391385 -0.7759139 0.7236082 0.7559682 -0.4727947 -0.63737476 0.4760205 0.67535037 -0.3208711 -0.6575056 -0.3873278 0.6085992 -0.46301785 -0.7493755 -0.38694748 0.45780277 -0.67139304 -0.48294586 0.5235286 0.7240925 -0.47864848 -0.58039856 -0.6609768 -0.51543784 0.56175715 0.41016892 0.5634009 -0.6101014 -0.7326862 0.75655276 0.49890596 -0.76903445; -0.30904213 -0.21409315 -0.4775963 0.42355645 0.41613275 -0.8161733 0.4479984 -0.6945146 0.5302272 0.73711616 -0.6770275 -0.67047256 -0.42029235 -0.39549905 -0.8350364 0.7012382 0.70009226 -0.48354647 0.9430724 -0.66683173 -0.70314544 -0.44897163 0.54288626 0.8196901 0.76365584 0.761553 0.3290329 0.79113716 0.79481435 -0.8187706 0.7286066 0.5562567 0.7096016 -0.70498955 0.6673103 0.51812565 0.5406621 0.7093701 0.46884313 -0.6145764 -0.55246305 -0.71489954 0.72012234 -0.5231047 0.40578407 -0.35232207 -0.5638624 0.42186224 0.83241993 0.38393915 0.61364543 0.6982443 -0.6831389 -0.7569969 -0.5150763 0.5752665 0.47449726 0.5053589 -0.42070308 0.6030154 -0.64933306 -0.6956285 -0.6349192 0.8312676 -0.7031198 -0.6573959 0.6030664 0.682057 0.80337685 -0.83292687 -0.5154852 -0.63579255 -0.58065146 0.6019924 0.45918357 -0.302554 -0.5323614 0.55788124 0.3794025 -0.7287361; -0.7496132 -0.5307996 0.40011656 -0.77036965 -0.68437475 0.48368964 0.5424029 -0.45423383 -1.0128791 -0.4666452 0.61701006 0.6640211 -0.44340664 0.3985603 0.46784642 0.70398754 -0.49079826 0.51983976 -0.5360467 0.45438114 0.4091419 -0.59362733 -0.7399472 0.6801782 -0.7291638 -0.5266998 -0.49648815 0.46552074 -0.76712525 -0.6889243 0.40933365 0.6965346 -0.77567476 0.48479497 -0.5443969 0.7215505 -0.55294687 0.72283447 -0.76929116 0.5564841 0.4290311 0.44701505 -0.53247535 0.5487699 -0.5698079 0.7153779 -0.44678032 -0.4684456 0.53430974 0.4480475 0.55019 -0.6281098 0.5136309 0.47552356 -0.44821912 -0.4650989 0.3897465 0.72669435 -0.5102333 -0.5088418 0.48885137 0.5046577 0.7577936 -0.77449226 0.90899855 0.9881354 -0.75857615 -0.7268491 0.44886932 0.5854408 0.61932325 0.549455 -0.48659918 0.9430092 -0.6497437 0.5200112 0.41194546 -0.6539289 -0.41493896 0.5568971; 0.68771726 0.63316095 -0.4366797 0.7062032 0.5867139 -0.53677005 0.4854811 0.53451407 0.41499627 0.5495023 -0.5479186 -0.6819315 0.48480013 -0.7433213 -0.7014589 0.3081471 0.5045917 -0.78765637 0.60495687 -0.48158908 -0.5932499 0.55737126 0.48223916 -0.74924445 0.6195087 0.46599257 0.7423314 -0.44989297 0.48018965 0.456159 -0.7801297 -0.56788945 0.46196747 -0.6842401 0.4946652 -0.6447668 0.64145833 -0.4615304 0.7882902 -0.6926555 -0.685144 -0.68319094 0.58204526 -0.6228568 0.4315907 -0.5238438 0.65509903 0.50661653 -0.47931296 -0.517804 -0.6317835 0.4996713 -0.72978586 -0.77571833 0.5591836 0.5501343 -0.7041699 -0.7223402 0.5908256 0.72526544 -0.5661058 -0.76907986 -0.75550497 0.44942003 -0.46921766 -0.6030852 0.4827196 0.60670257 -0.45109177 -0.70149046 -0.45105317 -0.7271935 0.771526 0.6341037 0.6386049 -0.46922383 -0.6570293 0.53906643 0.50885 -0.47111264; -0.48002467 -0.628842 0.7731417 -0.5377014 -0.7034583 0.7577504 0.716902 -0.7848673 -0.5195583 -0.6934648 0.7530647 0.78216314 -0.55568695 0.6288282 0.7578955 0.47404784 -0.5739199 0.78264076 -0.5190924 0.6595845 0.44401973 -0.5795202 -0.5921718 0.6810807 -0.7051322 -0.66568035 -0.48529455 0.4779483 -0.50498044 -0.49557552 0.55442727 0.6991036 -0.53626406 0.50523376 -0.46108222 0.5722775 -0.69759953 0.6792439 -0.7196129 0.5142946 0.42091557 0.7304495 -0.66078997 0.5365148 -0.5749098 0.5709899 -0.7738259 -0.67120653 0.7245357 0.761223 0.6194404 -0.70786196 0.526735 0.4905379 -0.72478426 -0.752012 0.530352 0.5441185 -0.43923444 -0.5701283 0.63576716 0.7571078 0.5273791 -0.51035166 0.44864258 0.48195347 -0.761842 -0.6297966 0.76170856 0.5016075 0.4740912 0.65874445 -0.79416054 0.58649504 -0.5669564 0.6777382 0.6818788 -0.5155111 -0.44187358 0.5190079; -0.71353984 -0.7719989 0.7822648 -0.50727 -0.46820065 0.7015942 0.676816 -0.67867893 -0.733811 -0.47752434 0.5442267 0.6446675 -0.4632439 0.62150884 0.6940245 0.443055 -0.4659506 0.41130084 -0.56409 0.69998467 0.68635887 -0.49398366 -0.49235684 0.7117962 -0.7148236 -0.5226371 -0.5777372 0.5657087 -0.65460944 -0.802919 0.5674169 0.78274155 -0.5593798 0.5136445 -0.4625511 0.45612094 -0.4758437 0.68116516 -0.5319779 0.6873551 0.60089445 0.5403197 -0.38865083 0.6218123 -0.4550472 0.41986483 -0.53855604 -0.715388 0.70137817 0.71555865 0.6058366 -0.7034659 0.50764155 0.44548327 -0.53545237 -0.51477206 0.58312035 0.71661645 -0.7788207 -0.69883156 0.74763316 0.42888972 0.61175007 -0.4370178 0.6217487 0.6109824 -0.65789443 -0.5380639 0.44908038 0.40560842 0.6099822 0.55097854 -0.67124045 -0.45243874 -0.61687034 0.5400641 0.7809359 -0.66001487 -0.5181012 0.5755703; 0.74954516 0.6503549 -0.67664576 0.52361846 0.5110265 -0.47302315 -0.47918543 0.6868703 0.71868086 0.50423336 -0.6302321 -0.4645221 0.75281715 -0.6566513 -0.48888084 -0.43435332 0.68738633 -0.4379741 0.7895946 -0.55715007 -0.6725263 0.6148717 0.45759347 -0.40819436 0.69367254 0.5720597 0.6959303 -0.5089431 0.5823938 0.5169289 -0.5536646 -0.4311388 0.7199394 -0.6870403 0.43923843 -0.41480944 0.78025 -0.42753977 0.6440575 -0.6975445 -0.47941637 -0.44419232 0.7356767 -0.7761705 0.51362866 -0.64019495 0.5973935 0.42245466 -0.5081794 -0.44302246 -0.5915592 0.58966845 -0.42110088 -0.5433069 0.79296213 0.68411463 -0.4793425 -0.76497614 0.7775636 0.6248421 -0.6783232 -0.50148296 -0.57765776 0.6162975 -0.72269434 -0.54894245 0.7607988 0.5320369 -0.5227486 -0.6994758 -0.6384114 -0.6228582 0.44501957 -0.7213937 0.6309387 -0.62849146 -0.44629827 0.5361145 0.7311981 -0.6577355; 0.6366116 0.7659777 -0.69351023 0.41797623 0.7525291 -0.6480912 -0.66389906 0.4429656 -0.49741763 0.6728207 -0.4880553 -0.6068991 0.5587453 -0.6857801 -0.71868074 -0.52364194 0.62344235 -0.47690582 0.419337 -0.45012972 -0.75970393 0.68683624 0.638237 -0.5790209 0.5511408 0.5828735 0.7341973 -0.6064098 0.8082008 0.4303623 -0.48659527 -0.64377373 0.5256058 -0.48476458 0.69115865 -0.76187986 0.6222213 -0.7053219 0.4574258 -0.6667776 -0.5303055 -0.6881434 0.62768006 -0.41280574 0.6752011 -0.4331248 0.752488 0.5680539 -0.6452187 -0.51372993 -0.65290254 0.42960623 -0.6296133 -0.4193381 0.47365683 0.67627656 -0.5642771 -0.60247046 0.52022 0.64258194 -0.5960361 -0.39927018 -0.7107255 0.7058979 -0.41148105 0.56550133 0.8021468 0.7224524 -0.4853527 -0.5042322 -0.48892245 -0.4466096 0.41145885 -0.79741347 -0.8031139 -0.42862996 -0.55803394 0.63080335 0.5108574 -0.52067715; -0.5134135 -0.5123622 0.5020601 -0.4426973 -0.67693543 0.6429734 0.6160542 -0.8187698 0.3406039 -0.592706 0.65739596 0.571161 -0.76531935 0.7438267 0.4769166 0.7822785 -0.6441503 0.519432 -0.56070745 0.7020592 0.8070796 -0.6887557 -0.6241351 0.55056596 -0.52354753 -0.574719 -0.48312756 0.5348675 -0.7026449 -0.620596 0.6610019 0.36014378 -0.43583974 0.6162854 -0.44915742 0.5770476 -0.5145052 0.78936774 -0.4556619 0.6280687 0.43889964 0.43058443 -0.7863518 0.6152782 -0.59755737 0.42101878 -0.68743163 -0.46881047 0.7262229 0.6874505 0.47470346 -0.46908075 0.7661981 0.7169746 -0.7424318 -0.66958165 0.42805958 0.54180163 -0.71804845 -0.4486706 0.51727295 0.586005 0.5148267 -0.5796865 0.60106647 -0.48930356 -0.5247357 -0.5873685 0.6856931 0.76906574 0.4540974 0.73425 -0.6594041 0.49708724 -0.64871645 0.47774428 0.6222796 -0.7132694 -0.64439756 0.7516629; -0.5403516 -0.58797586 0.41045728 -0.5119132 -0.66938215 0.6274715 0.64173895 -0.42397547 -0.44394588 -0.6643744 0.5538902 0.42045256 -0.6432319 0.41342416 0.65250385 0.7678386 -0.4262337 0.5576032 -0.7697621 0.4690696 0.62276906 -0.5278377 -0.6273249 0.44580868 -0.71153224 -0.4213768 -0.5148247 0.4530763 -0.680731 -0.77930766 0.5339513 0.52258855 -0.6895397 0.78822196 -0.4885927 0.42710236 -0.73505074 0.44140887 -0.7627625 0.7615296 0.7743539 0.54779345 -0.69873166 0.7326035 -0.59011257 0.4876964 -0.63781685 -0.49959332 0.596926 0.46269172 0.7743328 -0.61548907 0.6434421 0.46298704 -0.7803574 -0.5625159 0.689043 0.7341967 -0.45509318 -0.539705 0.45521325 0.49297297 0.55660355 -0.57115716 0.55993813 0.59343565 -0.75972253 -0.7089815 0.45348528 0.7229702 0.43376508 0.502588 -0.7153952 0.5642883 -0.53657055 0.4245418 0.41021502 -0.4244952 -0.4479969 0.6889104; -0.122480474 -0.3054617 0.4969116 -0.4812249 -0.6921367 0.49661598 -0.7089568 0.5361224 -0.46853733 -0.67804456 0.40039948 0.64550936 -0.42715296 0.69249356 0.40768462 -0.57306737 -0.43430725 0.6326841 -0.48716497 0.7688733 0.50689423 -0.067568354 -0.43562606 -0.43537983 -0.39556178 -0.62057734 -0.7039823 -0.73861295 -0.41842988 -0.5722996 -0.082849346 -0.75071555 -0.69023746 0.6329995 -0.66389287 -0.6559914 -0.6754419 -0.40430513 -0.44021657 0.694942 0.7950691 0.6614069 -0.62316114 0.72833425 -0.497366 0.5078976 0.49873003 -0.6428627 -0.6268832 -0.9358706 -0.8550728 -0.74219596 0.7079828 0.54853636 0.022284433 -0.4026834 0.52073747 0.11384505 0.5570582 -0.72725827 0.8013857 0.4582384 0.44679588 -0.5541284 0.7554864 0.43407932 -0.71908253 -0.54780066 0.7309959 0.5855661 0.5078271 0.5011512 -0.504169 -0.5671906 -0.53674394 0.599876 0.6428011 -0.6786759 -0.6929895 0.49884114; 0.7828101 0.5490794 -0.440142 0.41742155 0.6389467 -0.67498773 0.57446647 0.58191407 0.7910695 0.4537584 -0.77402955 -0.46161774 0.71310186 -0.6608966 -0.5184881 0.716436 0.6108254 -0.538533 0.6595058 -0.5920987 -0.5439749 0.4723593 0.77251065 -0.6780641 0.56098914 0.52370304 0.64737445 -0.4353894 0.5772262 0.64718175 -0.5915629 -0.6999137 0.56926155 -0.47750756 0.5256565 -0.6411358 0.7772079 -0.44733655 0.7270082 -0.50153595 -0.6590336 -0.62387705 0.66301876 -0.45593747 0.4061242 -0.6332918 0.70452684 0.5509786 -0.45451197 -0.51572645 -0.669381 0.46183103 -0.61867106 -0.65929836 0.55341625 0.6193807 -0.4377209 -0.68003494 0.6493854 0.49805862 -0.71202934 -0.5047355 -0.50473714 0.5856304 -0.49398634 -0.7480668 0.5648009 0.6414263 -0.3927099 -0.55431134 -0.5064755 -0.42684767 0.6254013 0.49704638 0.6287187 -0.50321335 -0.50068337 0.67385817 0.66489357 -0.74139327; 0.13372454 -0.32172117 0.62556034 -0.58139366 -0.540072 0.6664792 -0.6433067 0.49958023 -0.74784154 -0.61857307 0.68011075 0.7734335 0.22355923 0.6112726 0.783258 -0.7359094 -0.4326632 0.5916067 -0.68730754 0.4246772 0.66126996 0.3626277 -0.60251695 -0.85083455 -0.6731648 -0.7879253 -0.7224386 -0.6811644 -0.7254747 0.24311632 -0.47029558 -0.58872795 -0.38727045 0.4258338 -0.62143195 -0.83957297 -0.5364535 -0.750175 -0.59341073 0.34392968 0.6174882 0.43919653 -0.8795951 0.59596485 -0.663003 0.2768869 0.30173334 -0.4632289 -0.5913766 -0.47372478 -0.451823 -0.37147397 0.70180225 0.7530801 0.2062523 -0.72372675 -0.13624291 -0.27119675 0.605944 -0.45694894 0.6255184 0.5813316 0.60897213 -0.868114 0.58014315 0.48511994 -0.5008377 -0.64172024 -0.58711445 0.79221094 0.6353463 0.7126854 0.5270791 -0.38064393 -0.62363 0.18343182 0.4851226 -0.7190256 -0.69156927 0.69521934; 0.65741855 0.740752 -0.63934517 0.5365173 0.6406603 -0.64597535 -0.7090705 0.45291567 0.5048434 0.75284594 -0.47073364 -0.68203807 0.4476561 -0.39387268 -0.74140996 -0.5419021 0.43764713 -0.6932381 0.7857103 -0.44617912 -0.42397693 0.58569264 0.7379403 -0.67118746 0.53219855 0.5958871 0.5314002 -0.7516398 0.51498115 0.43866223 -0.43415165 -0.5449196 0.7030023 -0.5861635 0.56733507 -0.65357965 0.6721247 -0.53761846 0.73238677 -0.68789333 -0.48862705 -0.5255712 0.6382544 -0.5731746 0.50948066 -0.60567987 0.8062523 0.5247601 -0.74024284 -0.6443835 -0.7711069 0.62241316 -0.56500745 -0.49028492 0.58441824 0.57168907 -0.68104154 -0.44929138 0.48668137 0.7111409 -0.72954607 -0.44539523 -0.54581094 0.7125184 -0.5786441 -0.61586994 0.8069644 0.74855447 -0.5921249 -0.7046786 -0.65969193 -0.7985558 0.64215827 -0.47349304 0.7599688 -0.48227486 -0.77846915 0.6244479 0.5613691 -0.7509775; 0.7023714 0.69597155 -0.41328993 0.6833329 0.40383932 -0.74004036 0.75790447 0.6948525 0.52274823 0.76747036 -0.6843761 -0.6720126 0.77238965 -0.6166888 -0.5027556 0.6320027 0.5047611 -0.48909292 0.7543502 -0.7488936 -0.7583682 0.58462757 0.43051493 0.38512754 0.5584982 0.7907306 0.44822115 -0.60636574 0.7179379 0.73234755 -0.6624613 -0.2318172 0.6317222 -0.7498489 0.53396684 -0.45383215 0.8059558 -0.59319746 0.7447619 -0.53024924 -0.57041675 -0.45343474 0.4386712 -0.42811185 0.47862995 -0.7685942 0.4569496 0.59240943 0.54219294 -0.7916887 0.2426237 0.56051546 -0.7276443 -0.61418724 0.6040474 0.511354 -0.53699577 -0.6830555 0.006678439 0.39656475 -0.45618418 -0.7808125 -0.5517532 0.6579711 -0.47503197 -0.75454366 0.44830287 0.8215888 -0.6740015 -0.73140556 -0.5589251 -0.66684806 0.5727112 0.69310796 0.8002925 -0.7111009 -0.6210758 0.6176144 0.5451469 -0.53397334; -0.70805573 -0.6751506 0.41565883 -0.6732305 -0.7085539 0.7588127 0.7347971 -0.6910237 0.48297966 -0.7004693 0.67457527 0.5003778 -0.61897403 0.68226475 0.57656866 0.64589065 -0.5352747 0.6729389 -0.52693194 0.6140186 0.44116393 -0.618803 -0.47107953 0.6374462 -0.7644871 -0.7719454 -0.45441484 0.6272052 -0.5639696 -0.7999344 0.6080048 0.49935818 -0.6783342 0.43693402 -0.70939714 0.4117094 -0.7541376 0.4338829 -0.5009882 0.6281267 0.58006907 0.41783205 -0.61028445 0.68997204 -0.48893896 0.52413666 -0.6901428 -0.36339256 0.47197542 0.7104849 0.68594944 -0.5121178 0.74881107 0.69209856 -0.8157173 -0.64165974 0.40018213 0.4579485 -0.77832574 -0.41965544 0.34688157 0.5323071 0.59822345 -0.8509851 0.5477642 -0.5711899 -0.4464996 -0.69130605 0.59827644 0.8166294 0.5946243 0.6209534 -0.48656708 0.5558348 0.55517274 0.4247555 0.7777995 -0.62065995 -0.3270594 0.82833296; -0.46782804 -0.6533044 0.6926469 -0.4650665 -0.5667094 0.46124282 0.50556374 -0.5314658 -0.75655854 -0.6174003 0.7172839 0.6366178 -0.7461839 0.58806026 0.79405946 0.5166737 -0.64658654 0.55204946 -0.66524196 0.70622337 0.64966214 -0.7687876 -0.6207043 0.6355179 -0.662898 -0.5167526 -0.48705837 0.66879886 -0.4732223 -0.5739133 0.56211174 0.6596783 -0.76987594 0.6937879 -0.74483573 0.4487823 -0.7946208 0.6715037 -0.5898276 0.4181369 0.44822896 0.49546716 -0.70155495 0.4123381 -0.7785231 0.4899591 -0.6642129 -0.7687877 0.44632575 0.52929664 0.6162376 -0.751936 0.67887354 0.56182474 -0.51593256 -0.61278546 0.49784812 0.59198195 -0.7160694 -0.6970763 0.5086749 0.69884527 0.6730979 -0.75149786 0.74674314 0.5962947 -0.6006256 -0.61774373 0.67866355 0.6786929 0.5179666 0.5508364 -0.48576412 0.5469352 -0.476746 0.7730308 0.43664977 -0.6002259 -0.7249687 0.6735524; 0.7339676 0.52787566 -0.46672374 0.41959652 0.56429607 -0.6805647 -0.71233577 0.7657227 0.49802002 0.7700201 -0.74081206 -0.76122713 0.48408905 -0.59877986 -0.7786063 -0.5770069 0.7769251 -0.53252906 0.5235814 -0.6549202 -0.62257594 0.587387 0.7835655 -0.42752677 0.6553863 0.69394255 0.70239156 -0.4163432 0.7776571 0.54791254 -0.40339997 -0.43684256 0.7463227 -0.601053 0.5572004 -0.4887411 0.55072266 -0.4291423 0.6544241 -0.5061358 -0.5489491 -0.46105254 0.44931865 -0.488779 0.5589876 -0.4638291 0.4860469 0.747336 -0.44329858 -0.6510673 -0.5022911 0.7111771 -0.49155816 -0.7717542 0.5112535 0.5766449 -0.5083659 -0.44709307 0.68161505 0.5272889 -0.5475684 -0.76339686 -0.63215697 0.49286523 -0.6694708 -0.6828071 0.7952328 0.47658285 -0.49428186 -0.77342117 -0.4368847 -0.61585563 0.5116722 -0.49189392 0.72896135 -0.7721414 -0.528916 0.57772434 0.74887997 -0.7709018; 0.60552067 0.735343 -0.6945216 0.5114641 0.45832837 -0.5248009 0.7012155 0.7164846 0.6721917 0.43360737 -0.7477773 -0.6773528 0.4626191 -0.6966696 -0.60508674 0.119832285 0.69723594 -0.5349653 0.5983386 -0.48975995 -0.40476677 0.73048574 0.7128381 -0.59095824 0.729443 0.66909987 0.7215927 -0.76386064 0.7052405 0.47729352 -0.61459684 -0.74955994 0.7090777 -0.5695981 0.5960302 -0.5240732 0.4967331 -0.5344507 0.53341573 -0.5400051 -0.46659508 -0.6358773 0.76913005 -0.4427209 0.6651705 -0.7897796 0.7465438 0.6260695 -0.55634904 -0.6124499 -0.61462265 0.65939295 -0.6365304 -0.49346548 0.62721723 0.56614316 -0.61401296 -0.7278227 0.3966796 0.7840623 -0.47736004 -0.6147928 -0.4176814 0.63229364 -0.41400838 -0.70780885 0.60732144 0.7346618 -0.6370311 -0.7685072 -0.54513097 -0.7150524 0.5780642 0.51603055 0.7326087 -0.6487408 -0.7062145 0.59824485 0.5503905 -0.66697407; 0.52393955 0.71338195 -0.48038518 0.65845096 0.57581985 -0.58505464 -0.5471435 0.44082746 -0.16822177 0.53766835 -0.6113201 -0.40821978 0.5105583 -0.79389167 -0.60587853 -0.7667177 0.489345 -0.55240196 0.70359397 -0.57765126 -0.7866079 0.7466269 0.6237585 -0.6634179 0.5697219 0.8184007 0.64339346 -0.5240345 0.5116607 0.4521228 -0.7614733 -0.74931407 0.47578695 -0.4906365 0.7721375 -0.49540156 0.67287886 -0.69907033 0.52938133 -0.4288202 -0.54573077 -0.6942226 0.52248406 -0.5640808 0.7910684 -0.4515992 0.6273957 0.42351574 -0.5054742 -0.61430246 -0.5767827 0.6542661 -0.667393 -0.46506616 0.6713231 0.5494492 -0.55920744 -0.51373017 0.7503128 0.5076025 -0.72219115 -0.4553161 -0.5958113 0.3938615 -0.6470306 0.31013978 0.64667374 0.47617272 -0.79641855 -0.72584724 -0.51223946 -0.41142017 0.70141196 -0.76058036 0.8324752 -0.54569525 -0.66891617 0.7110105 0.59661794 -0.43874165; 0.7092731 0.53627485 -0.5726121 0.6031641 0.6202353 -0.68959093 -0.7914677 0.4971433 0.52474463 0.71740323 -0.41609693 -0.5754202 0.6405522 -0.6711487 -0.45343575 -0.5096235 0.6499169 -0.7495636 0.78148156 -0.6264123 -0.6976634 0.65014786 0.738073 -0.77952623 0.57116854 0.61997485 0.6373128 -0.6030749 0.63912445 0.5894538 -0.5648235 -0.6989532 0.4585608 -0.7487265 0.580233 -0.76711905 0.5604347 -0.47802994 0.48583606 -0.41022542 -0.46199507 -0.41773957 0.76761043 -0.60503066 0.54041046 -0.6114589 0.7535691 0.5293309 -0.41204748 -0.7550046 -0.43082154 0.6180089 -0.49779248 -0.72829944 0.62432176 0.72092015 -0.7107658 -0.48577362 0.7424561 0.53875715 -0.7591517 -0.5520447 -0.5646478 0.562351 -0.3040891 -0.66448945 0.494854 0.43897447 -0.5792426 -0.7879099 -0.4257585 -0.6675051 0.43069115 -0.39889696 0.65610754 -0.59485185 -0.5421989 0.7026429 0.55080765 -0.7810169; -0.62236685 -0.5846399 0.7032341 -0.48322555 -0.6444562 0.45737895 0.57159585 -0.41714072 0.41037908 -0.53789693 0.6418366 0.5497949 -0.637541 0.5301011 0.48842937 0.43437845 -0.5736746 0.4236751 -0.43473879 0.72240484 0.6034561 -0.59753877 -0.8785602 0.49276975 -0.7615806 -0.75267154 -0.54993486 0.54641426 -0.526135 -0.76206726 0.7133399 0.6610564 -0.46109793 0.76239544 -0.5444518 0.6977077 -0.80544347 0.74002534 -0.535566 0.4790489 0.41658124 0.50843984 -0.6222002 0.630301 -0.4393125 0.6698724 -0.48684362 1.101669 0.6666257 0.6966207 0.48817548 -0.41418755 0.39971069 0.5098984 -0.66601485 -0.5773281 0.40454784 0.5202625 -0.6140818 -0.49911103 0.44719586 0.4266925 0.48383054 -0.7432485 0.8364198 -0.59021753 -0.52929986 -0.52632457 0.41423613 0.63651276 0.55294335 0.4100498 -0.5999856 0.63679534 0.6398303 0.4736463 0.6562569 -0.7068965 -0.1349062 0.685158; 0.5320693 0.56764287 -0.4087551 0.69499546 0.48760265 -0.71030504 -0.41244513 0.43732744 0.76619047 0.4372734 -0.75022805 -0.71490794 0.48184192 -0.5505507 -0.66980445 -0.6949599 0.7584606 -0.558278 0.6788917 -0.46409068 -0.5000998 0.7020343 0.6455357 -0.77406573 0.4364711 0.57059336 0.7686845 -0.7793205 0.62902963 0.65867025 -0.46846506 -0.6123406 0.43034688 -0.50538373 0.7168116 -0.75473887 0.757945 -0.5520746 0.40699944 -0.47149122 -0.77422565 -0.55687475 0.48305568 -0.46563306 0.41356024 -0.4702882 0.64382595 0.45271105 -0.555819 -0.43810079 -0.7063173 0.4807889 -0.4144581 -0.45407808 0.4554496 0.53747445 -0.6757026 -0.793431 0.49504998 0.46147892 -0.4744659 -0.76103073 -0.6594437 0.45691153 -0.54774433 -0.7477778 0.6466124 0.5773149 -0.5408681 -0.784783 -0.412031 -0.6385539 0.6235819 -0.48012945 0.71367705 -0.44018555 -0.7922371 0.42986715 0.59942573 -0.7863954; -0.42737484 -0.6189005 0.81554466 -0.7073221 -0.7247965 0.62966084 0.68818045 -0.5922808 0.39628145 -0.6310056 0.49946028 0.55441254 -0.39884692 0.59364104 0.58791447 0.5205707 -0.69266266 0.5950259 -0.38413024 0.45524564 0.74437803 -0.7669656 -0.5689781 0.5016915 -0.4088136 -0.5022785 -0.43352923 0.57435054 -0.41890088 -0.696453 0.76533544 0.48313037 -0.43664342 0.5531424 -0.5349502 0.6955337 -0.73161846 0.548788 -0.5682023 0.6300682 0.6048296 0.68738 -0.7259658 0.4976744 -0.8015935 0.761104 -0.6278941 -0.35106376 0.6573266 0.6130824 0.76378316 -0.45652565 0.5668269 0.54305047 -0.62557954 -0.7526371 0.7267266 0.65469056 -0.60104084 -0.8073816 0.62232876 0.61113083 0.69847655 -0.7859864 0.5698679 -0.4635615 -0.42099762 -0.5415391 0.616613 0.47614208 0.5417833 0.6640008 -0.79082394 0.5554717 0.5454851 0.67009294 0.47868785 -0.59374994 -0.7075662 0.51641476; 0.7812537 0.5699077 -0.4344669 0.56537807 0.7638959 -0.6868138 -0.7135387 0.5814462 -0.33648008 0.5787966 -0.7924472 -0.4271694 0.59405524 -0.55594355 -0.652688 -0.6550669 0.41008258 -0.4620316 0.66131043 -0.67533845 -0.67291594 0.5209923 0.7819197 -0.39687335 0.5060334 0.42044026 0.5279163 -0.42923057 0.6554885 0.593351 -0.53541124 -0.81004715 0.51683843 -0.6265435 0.710522 -0.4540583 0.74693 -0.5698698 0.5465993 -0.6221454 -0.53330225 -0.52796835 0.70606655 -0.49374428 0.49649176 -0.43498895 0.6136046 -1.0502822 -0.553598 -0.43921408 -0.55052245 0.5551949 -0.60656005 -0.52551687 0.76476496 0.5487271 -0.54710245 -0.5094373 0.7312516 0.6928913 -0.59008586 -0.5167332 -0.75405234 1.0022908 -1.012585 0.60465467 0.6173512 0.79551065 -0.5377603 -0.79347444 -0.43854898 -0.78574777 0.61427796 -0.44118106 -0.7208069 -0.4256511 -0.68402886 0.50915056 -0.8880569 -0.53080606; -0.75404465 -0.4158255 0.6499218 -0.56592387 -0.6778984 0.5421315 -0.4271178 -0.7380747 -0.7843769 -0.5136523 0.50360173 0.5903103 -0.5728338 0.61098534 0.7441951 -0.7083524 -0.41511625 0.7748788 -0.46475923 0.59171337 0.6796391 -0.5605705 -0.55154103 0.4132476 -0.5929445 -0.45662266 -0.6414344 0.65529287 -0.477383 -0.63707244 0.4680381 0.6887911 -0.424281 0.68333787 -0.46510848 0.6511818 -0.78952575 0.6154758 -0.464636 0.65584624 0.4927487 0.44001773 -0.54923993 0.65178746 -0.577395 0.5022792 -0.54560995 -0.62102133 0.4537468 0.6109702 0.56169564 -0.7546615 0.5472703 0.4445263 -0.5248962 -0.65597105 0.593691 0.43419135 -0.6567327 -0.41037387 0.4941371 0.66939646 0.4623368 -0.6836278 0.59875536 0.7764998 -0.6886097 -0.608124 0.62828445 0.60947526 0.42779967 0.7570759 -0.44127104 -0.5671585 -0.79039323 0.7817238 0.6634353 -0.5147918 -0.41522402 0.5479836; -0.42031527 -0.6152916 0.61713684 -0.6283293 -0.5513891 0.7388568 0.73667574 -0.79333794 -0.46097776 -0.5769372 0.45963648 0.7638919 -0.41144875 0.41193232 0.7211403 0.44407123 -0.7840698 0.43467 -0.7887383 0.55275345 0.5583938 -0.6793731 -0.53963214 0.71878463 -0.70869017 -0.4304214 -0.5658015 0.50626403 -0.7090023 -0.5336333 0.45289588 0.73166054 -0.6692311 0.7133885 -0.4979025 0.45428735 -0.73019797 0.740162 -0.6448324 0.4775607 0.7688322 0.75112975 -0.7587264 0.6862017 -0.4537361 0.6828685 -0.57160467 -0.46255133 0.42029387 0.74672014 0.64171785 -0.43284568 0.77293515 0.5138823 -0.7541793 -0.45271334 0.72840786 0.53195846 -0.6119828 -0.65435684 0.77139074 0.57238567 0.7395476 -0.38930652 0.6512884 0.43766454 -0.7469068 -0.7489934 0.53949875 0.5818304 0.5457432 0.57676524 -0.629142 0.60381275 -0.51520574 0.69839114 0.5885781 -0.53343105 -0.61960864 0.50317174; -0.6751811 -0.41880053 0.48926488 -0.7120828 -0.68126994 0.7777727 0.6585125 -0.61105645 -0.4844474 -0.73120743 0.63580984 0.66195035 -0.74377894 0.5206554 0.72406256 0.7906858 -0.5110751 0.67801815 -0.8079643 0.6893134 0.49131075 -0.65974414 -0.7478776 0.45650548 -0.60964155 -0.4016337 -0.61026895 0.5389646 -0.41972703 -0.42120355 0.6887967 0.47597688 -0.48931286 0.47068337 -0.54607534 0.5319589 -0.7065352 0.60842025 -0.56068486 0.50083077 0.69012 0.59217167 -0.6435814 0.57170504 -0.7192252 0.7812268 -0.527284 -0.59788245 0.53182167 0.45099434 0.7276154 -0.6755215 0.44986445 0.4431063 -0.56311095 -0.69906956 0.73365504 0.76098704 -0.63417983 -0.4675469 0.5653513 0.5777887 0.49386287 -0.6340162 0.5468726 0.6280008 -0.5516831 -0.4956879 0.72152406 0.76413286 0.6935004 0.7563873 -0.7724173 -0.6480348 -0.75537115 0.4888865 0.7713178 -0.46787387 -0.46547928 0.7981122; -0.513397 -0.67958945 0.5036607 -0.4910333 -0.46967444 0.40301096 0.6401685 -0.48608148 0.4894924 -0.68090427 0.71370256 0.6827149 -0.5271162 0.8165343 0.6205225 0.72073513 -0.6230092 0.68515587 -0.63522875 0.5463678 0.8068648 -0.4405838 0.4409796 0.50929224 -0.5701658 -0.51363236 -0.4194547 0.53867084 -0.6276575 -0.57194465 0.7218151 0.7322298 -0.42279392 0.58535975 -0.7081732 0.550008 -0.4520289 0.7399854 -0.50196093 0.6731514 0.50369537 0.7865832 -0.5588892 0.5985157 -0.81002384 0.6864013 -0.73462033 0.69197613 0.81490064 0.6839305 0.48328105 -0.72150975 0.49716344 0.5243065 -0.6881175 -0.7009553 0.49567404 0.5228505 -0.4371503 -0.4664979 0.4595053 0.5723943 0.49724638 0.34406102 0.092064776 -0.7202968 -0.5043109 -0.45451608 0.6978905 0.5756205 0.56158555 0.5778875 -0.5536276 0.451845 0.6963856 0.55275506 0.7004316 -0.52949554 0.7564763 0.7049032; -0.48889914 -0.721826 0.5823641 -0.5980677 -0.5805978 0.6813893 -0.6652564 -0.7525123 -0.5772457 -0.54579294 0.62497693 0.78640985 -0.6569967 0.5935933 0.5684411 -0.56871986 -0.7216905 0.57668763 -0.7031327 0.683219 0.6720175 -0.4455124 -0.73428404 -0.29469615 -0.6432448 -0.75259304 -0.7306039 0.7129554 -0.72432965 -0.6426137 0.70973 0.1477224 -0.75088024 0.4740075 -0.57253695 0.42699382 -0.47631782 0.58905995 -0.55501634 0.75878215 0.45258632 0.63939553 -0.46401483 0.6512765 -0.71725404 0.45646158 -0.7497642 -0.530433 -0.5060116 0.6997208 0.29076168 -0.770036 0.45654014 0.5546336 -0.71590483 -0.56746924 0.50725526 0.6473104 -0.5496293 -0.6549688 0.4719398 0.64835155 0.6938321 -0.62348014 0.73073417 0.5375414 -0.79593515 -0.55704856 0.67760986 0.5215144 0.5807682 0.5581976 -0.666048 -0.58264756 -0.5437203 0.70259935 0.7682578 -0.6251781 -0.43706015 0.61451596; 0.4202459 0.3684912 0.7680594 -0.7588142 -0.6745364 0.5982692 -0.5072195 0.4936619 -0.7093542 -0.7799437 0.5316932 0.51776934 0.5910468 0.6596391 0.4065284 -0.43628323 -0.55100083 0.5363974 -0.19130138 0.7502931 0.63020825 0.52279514 -0.7140893 -0.72312164 -0.4632635 -0.5794786 0.35390005 -0.6804287 -0.65709794 1.2581941 -0.6572041 -0.6876481 0.082076795 0.6356307 -0.6110546 -0.56129104 -0.4379704 -0.43215734 -0.5166199 0.5142374 0.62932295 0.82419723 -0.73230904 0.69100285 -0.7616086 0.7163677 0.7019235 -0.6813852 -0.52422166 -0.40911758 -0.6607348 -0.65204084 0.45776978 0.8236383 0.3942182 -0.47122085 -0.42271337 -0.67046326 0.688935 -0.6597749 0.4647675 0.62954617 0.55296767 -0.515041 0.27015987 0.710869 -0.5771075 -0.53592724 -0.50828254 0.6785514 0.5366799 0.5034525 0.5223959 -0.5334808 -0.4887378 0.41606772 0.6956623 -0.74656916 -0.75263476 0.7465036; -0.57148606 -0.6091424 0.501723 -0.7999108 -0.8346436 0.48617885 0.61279804 -0.6794264 -0.40040988 -0.6993855 0.46966922 0.57989496 -0.6621052 0.70493704 0.56388557 0.85146093 -0.68402934 0.47056797 -0.61159337 0.7376382 0.7002303 -0.59747154 -0.65008307 0.48999193 -0.7319892 -0.42441285 -0.4789409 0.5268726 -0.7306186 -0.4955883 0.8299547 0.6903011 -0.41915795 0.51188684 -0.51958835 0.47971413 -0.36265555 0.58012396 -0.7518603 0.74729735 0.65666264 0.5306888 -0.57441866 0.5155436 -0.5639437 0.6832964 -0.5739611 -0.64135224 0.8495929 0.5696289 0.35469857 -0.8107977 0.52028495 0.66495067 -0.6275 -0.7045054 0.5474082 0.7384729 -0.5087969 -0.7456807 0.57829136 0.6275214 0.60390705 -0.53550494 0.26351228 0.48518124 -0.6450895 -0.44784415 0.80110806 0.45506564 0.5056692 0.55687845 -0.5812806 -0.061251022 -0.31556574 0.82632613 0.5923927 -0.523149 -0.813353 0.5031365; -0.76105225 -0.60851264 0.43860152 -0.6585335 -0.58868676 0.5869993 0.7765042 -0.6027596 -0.7204184 -0.48872355 0.424127 0.4484882 -0.63739085 0.5989677 0.45921955 0.65642804 -0.7048243 0.64453673 -0.6091709 0.52982473 0.700694 -0.43890646 -0.421691 0.5156799 -0.6695245 -0.5627812 -0.7545495 0.64208686 -0.5904866 -0.7506932 0.5417207 0.72443897 -0.750619 0.5061591 -0.4757703 0.4497669 -0.42007044 0.48355913 -0.56456006 0.5204332 0.48012692 0.7314382 -0.6971607 0.53881234 -0.40689182 0.44969693 -0.6593883 -0.4519129 0.6933792 0.51274425 0.7076796 -0.60174775 0.5707203 0.71528006 -0.5763611 -0.7880375 0.41654238 0.67710984 -0.62433475 -0.52692366 0.55887 0.7291613 0.62648576 -0.6858593 0.6564427 0.40214524 -0.74215513 -0.6466137 0.77746034 0.64807206 0.4113152 0.7276054 -0.5085308 0.42352685 -0.7612914 0.40811512 0.6370973 -0.4056059 -0.48416102 0.6300048; 0.6809307 0.63965565 -0.65337306 0.5197365 0.6117968 -0.8341221 -0.58784986 0.5003326 -0.43256858 0.760617 -0.592628 -0.8536069 0.83981234 -0.4894709 -0.7759528 -0.5635388 0.43326166 -0.72408456 0.7805408 -0.66126025 -0.65256625 0.52851427 0.38379908 -0.5279926 0.6058467 0.44418162 0.64837295 -0.42157164 0.5404939 0.61184615 -0.3945014 -0.48139057 0.5148505 -0.6099841 0.477654 -0.7092938 0.7958249 -0.4659826 0.7195855 -0.42085844 -0.6656427 -0.7460753 0.50178826 -0.4308091 0.6253241 -0.50344753 0.8680208 -0.5841727 -0.52577025 -0.62610704 -0.84186304 0.3561656 -0.4155569 -0.701557 0.83544356 0.78196245 -0.38587794 -0.72460955 0.55641085 0.70544094 -0.3917686 -0.7380938 -0.592075 0.53180087 -0.28660974 0.70293164 0.8241966 0.5773481 -0.4263706 -0.59292996 -0.49278584 -0.508712 0.54519564 -0.6134349 -0.5861975 -0.46959436 -0.8168518 0.63089085 -0.90944105 -0.6418886; -0.5383652 -0.6864861 0.5003324 -0.70500326 -0.5976665 0.44939128 0.5431101 -0.4495138 -0.59850925 -0.4705612 0.6820087 0.44072068 -0.6885281 0.46132654 0.7551483 0.4189402 -0.6288839 0.5425192 -0.4385118 0.47117987 0.6437869 -0.61291856 -0.4730796 0.73018205 -0.5506932 -0.54266256 -0.5919883 0.759773 -0.6489544 -0.6539806 0.66511625 0.72194856 -0.6986801 0.42493582 -0.6325659 0.53447044 -0.47501317 0.5425436 -0.69004124 0.44503817 0.7746933 0.4930632 -0.45072177 0.42377555 -0.71026707 0.48050553 -0.5454317 -0.7316462 0.6206054 0.4285525 0.6928556 -0.71364725 0.41971004 0.5866537 -0.49963158 -0.55969286 0.7039792 0.7710892 -0.58839816 -0.53594464 0.60900724 0.65726334 0.59513754 -0.49922073 0.7332286 0.70300597 -0.73307514 -0.76920134 0.672928 0.50187844 0.7096587 0.74950534 -0.52912223 -0.5957069 -0.7448634 0.5948331 0.64733857 -0.5421028 -0.4807019 0.63530505; 0.4664607 0.69170076 -0.52513444 0.5643994 0.45393184 -0.54006195 0.69723296 0.7784226 0.5041563 0.65567863 -0.4505268 -0.48744795 0.7474246 -0.59535563 -0.6591164 -0.39855427 0.67484546 -0.686476 0.44450602 -0.55894876 -0.41452992 0.7372297 0.7927382 -0.77565 0.62059057 0.63127214 0.62449676 -0.757737 0.60901046 0.6753761 -0.7402596 -0.54901606 0.8163592 -0.44413304 0.5847393 -0.39297777 0.78882957 -0.5339406 0.69867605 -0.389354 -0.48681888 -0.58088535 0.8136405 -0.4497965 0.58615744 -0.7408903 0.57261926 0.5552009 -0.49549192 -0.48485222 -0.5739754 0.45838013 -0.3849317 -0.51280856 0.6261394 0.4376636 -0.76476884 -0.77451825 0.7245031 0.6747901 -0.64296997 -0.61396736 -0.5785009 0.45383582 -0.67449987 -0.5195049 0.47065508 0.74715537 -0.44515252 -0.6384955 -0.3955766 -0.5831793 0.48093182 0.72363794 0.587963 -0.50297534 -0.5239703 0.48622724 0.48101833 -0.45201096; 0.8130188 0.5226381 -0.7443081 0.57170576 0.7327329 -0.4429129 -0.60711646 0.6931794 0.4880975 0.7917323 -0.5042733 -0.6101661 0.7485851 -0.42009148 -0.6698345 -0.76164514 0.54268104 -0.50605804 0.74297595 -0.5381612 -0.6642722 0.679142 0.56886667 -0.44523618 0.77689445 0.8161075 0.4404374 -0.44035798 0.68435055 0.58848363 -0.5758335 -0.78504443 0.7368085 -0.66056156 0.40261137 -0.5320851 0.75950533 -0.5016163 0.5845184 -0.65031075 -0.5869411 -0.5721848 0.6424166 -0.5763758 0.5144273 -0.4287461 0.65648514 0.70781887 -0.5542557 -0.6632486 -0.5621437 0.526139 -0.7633234 -0.7052387 0.65100414 0.54430544 -0.4838219 -0.7764267 0.4773174 0.62776446 -0.43156564 -0.6533344 -0.6986548 0.46812168 -0.59610057 -0.6012207 0.69718313 0.7227249 -0.4445767 -0.48299408 -0.5792412 -0.56931967 0.43276608 -0.5093734 0.47093946 -0.5378987 -0.47803184 0.50555557 0.67655027 -0.64885134; -0.7690214 -0.47986692 0.16396153 0.049398635 0.6712062 -0.7184723 0.57005745 -0.6963028 0.745346 0.5464946 -0.6274961 0.5078386 -0.586677 -0.8072485 -0.66579205 0.43152416 -0.5617599 0.16644387 -0.43449804 -0.53271717 -0.72633004 -0.4642171 0.45594263 0.74920326 -0.7171133 -0.22067837 -0.56011117 0.7646857 -0.350467 -0.62114614 0.71529484 0.65880597 -0.6967354 0.124855235 0.82914674 0.39160708 0.39671135 0.7364667 0.82236123 0.44982475 -0.9952223 -0.9302703 -0.47955355 -0.5268705 0.605151 0.5649663 -0.5372328 0.62365395 0.710907 0.5271231 0.55982727 0.71362484 0.64083844 -0.45932782 -0.56653357 -0.4896482 0.57781833 0.6071833 -0.6443601 0.7573914 -0.6142848 0.66029567 0.46001127 0.44541064 -0.53878313 -0.5884046 0.16545159 0.3777917 0.57415605 0.660998 -0.79623574 0.6694115 -0.6543524 0.7034216 0.4205898 0.33236223 -0.3716564 1.0363767 0.5967717 0.45807627; -0.77787346 -0.72867596 0.68396825 -0.7103373 -0.5581834 0.6732779 0.6096178 -0.7086001 0.40174395 -0.6008474 0.66386783 0.80180556 -0.6156131 0.5258981 0.60133183 0.53143346 -0.4454659 0.5535201 -0.64148825 0.41238827 0.57540196 -0.60040903 -0.1615685 0.548129 -0.5532499 -0.46243352 -0.6403402 0.57306814 -0.73257476 -0.6355807 0.58996373 0.63522136 -0.4478934 0.6642295 -0.7419915 0.49833447 -0.75267303 0.4253562 -0.38738176 0.7591512 0.5721043 0.48183772 -0.5016191 0.71405053 -0.44459337 0.49500942 -0.52154666 0.9263063 0.6189416 0.5266508 0.61623704 -0.49788594 0.59838957 0.50497353 -0.608741 -0.50283056 0.4707992 0.7268853 -0.4948439 -0.5373639 0.4799579 0.7020672 0.5423573 0.14848344 0.36852607 -0.5760345 -0.52705634 -0.8185464 0.65602475 0.6146311 0.7403331 0.5849842 -0.6644905 0.83032876 0.47861463 0.4566145 0.5762968 -0.6758651 0.786152 0.7008493; 0.49285802 0.52731013 -0.60906225 0.5284188 0.6039899 -0.4033924 0.94574356 0.7400335 0.35364774 0.6551389 -0.38217473 -0.49248976 0.38371953 -0.5566175 -0.4318981 -0.6664709 0.65067893 -0.5888822 0.4330796 -0.5452598 -0.45253953 0.68201107 0.7558791 -0.854993 0.46093366 0.43229833 0.57343185 -0.7244555 0.50981283 0.67704827 -0.7817494 -0.48524994 0.750455 -0.7918607 0.5446602 -0.71992105 0.58473015 -0.70548457 0.5178561 -0.65629095 -0.61877316 -0.7589496 0.45584387 -0.6740585 0.7046093 -0.80059755 0.54625005 0.6279796 -0.5248488 -0.56588626 -0.40621167 0.43513095 -0.5325196 -0.7668108 0.7304903 0.6580746 -0.72765756 -0.7034119 0.6220387 0.4867193 -0.5241871 -0.49974114 -0.78053355 0.54489404 -0.58727235 -0.7210579 0.39811233 0.5641159 -0.7280104 -0.65158254 -0.7282224 -0.47902167 0.4800032 0.65571976 0.6987689 -0.4976253 -0.6450115 0.44219777 0.68303347 -0.42629772; 0.4499329 0.6762169 -0.6287315 0.72597206 0.54629827 -0.56926185 -0.7340511 0.41039878 0.5391339 0.63877875 -0.7271348 -0.6298107 0.62075096 -0.43867192 -0.46426478 -0.40934253 0.4085519 -0.49746343 0.7407428 -0.6735628 -0.7297381 0.5305748 0.47319368 -0.41608438 0.63479793 0.47402424 0.48273662 -0.6086235 0.7245033 0.4431723 -0.5239909 -0.7445051 0.79867923 -0.5657389 0.4860663 -0.64633155 0.7678837 -0.5685866 0.49433714 -0.74137306 -0.543166 -0.6458475 0.75004154 -0.4297481 0.47648248 -0.5083502 0.6380525 0.5167554 -0.70929646 -0.7140316 -0.5035231 0.4535759 -0.7224138 -0.58518505 0.442889 0.65504116 -0.5428939 -0.56715405 0.5445808 0.4102617 -0.5045267 -0.5362228 -0.57547075 0.75722414 -0.5778405 -0.6532132 0.5506445 0.7696102 -0.6876581 -0.4305488 -0.5261865 -0.6539704 0.49526057 -0.70795745 0.77495056 -0.5828182 -0.6000441 0.5144034 0.62885535 -0.64625096; 0.4811673 0.6808926 -0.7483987 0.5614281 0.6261887 -0.70686287 -0.5392155 0.65902007 0.5040249 0.6572258 -0.76192576 -0.5851471 0.6345992 -0.72812724 -0.73882836 -0.49623445 0.5632907 -0.54634905 0.47591832 -0.7674347 -0.62455237 0.6294456 0.6701113 -0.5323116 0.42365855 0.50540215 0.67457104 -0.47373366 0.68915284 0.5290887 -0.75426877 -0.59222513 0.4764365 -0.43209082 0.49448034 -0.525328 0.71504474 -0.43172613 0.5382474 -0.56365335 -0.6429082 -0.4248043 0.52890676 -0.73951554 0.63372326 -0.71126324 0.49038634 0.42576236 -0.69798297 -0.6927626 -0.41367537 0.4337574 -0.5472326 -0.462672 0.69665796 0.62955886 -0.54312575 -0.60372627 0.5109462 0.58366627 -0.67020047 -0.5909956 -0.6744217 0.78192896 -0.6844059 -0.4548956 0.69269913 0.6986985 -0.76526594 -0.44199282 -0.4540427 -0.681146 0.4822396 0.49191394 0.625656 -0.5208801 -0.41425008 0.43145388 0.5296371 -0.7422694; 0.49586955 0.47843313 -0.65117884 0.6871801 0.4641212 -0.7633004 -0.46765748 0.64401364 -0.42061532 0.51743525 -0.7373597 -0.70167565 0.46215153 -0.8087066 -0.43669873 -0.77274525 0.5544361 -0.6548398 0.5895363 -0.7430712 -0.649477 0.4657063 0.39906976 -0.7780709 0.6983372 0.5258039 0.67394924 -0.7590613 0.57454324 0.7045619 -0.5347957 -0.74446964 0.53336 -0.6996326 0.6575264 -0.5916548 0.54424286 -0.74084514 0.43988267 -0.59554094 -0.4917023 -0.72527766 0.47621956 -0.7099146 0.45488507 -0.512366 0.4624578 0.2680877 -0.6520534 -0.6210011 -0.41624284 0.4669532 -0.799281 -0.76627755 0.5812702 0.7093326 -0.43667284 -0.5649711 0.47892094 0.64573044 -0.48457918 -0.66266227 -0.4871485 0.7804619 -0.66228014 0.69701225 0.53614914 0.74703 -0.56991446 -0.6507211 -0.47645965 -0.38652572 0.6620979 -0.7922601 -0.39351052 -0.6305195 -0.6801774 0.6569189 0.60263866 -0.67454964; -0.73172235 -0.65982324 0.6942937 -0.50468034 -0.41712865 -0.28422207 0.8136759 -0.58044106 0.37829882 -0.7352141 0.80808806 0.5223071 -0.7529714 -0.87318826 1.3693999 0.54547346 -0.54684824 0.6459191 -0.58653307 -0.5765544 0.58194983 -0.58660173 0.52854186 0.6351265 -0.54495806 -0.68944764 -0.6410095 0.6162369 -0.47188532 -0.49320582 0.6742865 0.5756722 -0.6612572 0.54524153 -0.68584996 0.4536737 0.38984868 0.60902643 0.74581623 0.45835876 0.43299958 0.48959103 -0.6013921 0.48344076 -0.25286123 0.4788452 -0.5402114 0.5804927 0.67048246 0.5158315 0.76820314 0.911889 0.3625644 -0.7808554 -0.6299025 -0.48487365 0.39184186 0.62159216 -0.48822224 0.4484387 -0.55747896 0.6253022 0.67154545 0.3675698 0.028744757 -0.38138595 -0.8588262 -0.84376395 0.4549873 0.7078395 0.50750303 0.7080831 -0.51113224 0.5552823 0.3883643 0.17410578 0.826347 -0.58924603 0.8395851 0.7289325; -0.59750414 -0.64736307 0.71525395 -0.72400683 -0.7224773 0.6347891 0.49818236 -0.6711819 0.66633725 -0.6142192 0.52128285 0.5705848 -0.5729291 0.55103827 0.46990538 0.73967713 -0.5728069 0.4453322 -0.5952624 0.61517495 0.5357559 -0.5662474 -0.62517905 0.6401374 -0.72650605 -0.5291514 -0.6823668 0.7093865 -0.5777252 -0.5473495 0.44758454 0.61600006 -0.52349824 0.612774 -0.7665886 0.57266897 -0.6915436 0.55584383 -0.5022255 0.59065217 0.59182096 0.5250529 -0.6801346 0.6195984 -0.5216185 0.79191303 -0.5220087 0.5173806 0.54257166 0.45205203 0.69501984 -0.5896569 0.6958791 0.6132391 -0.51060545 -0.5802387 0.5877915 0.37088487 -0.7106178 -0.78296953 0.6025275 0.6725331 0.5443697 -0.72967225 0.55195624 -0.7031292 -0.71110463 -0.67831457 0.7048129 0.5934182 0.60049504 0.53380525 -0.7670599 0.4889391 0.44907925 0.7997933 0.53301466 -0.52705544 -0.66492265 0.7338274; 0.7937895 0.73742867 -0.72770464 0.75391185 0.57656103 -0.7404645 0.46710274 -0.34503967 0.7612536 0.8158844 -0.4479233 -0.6956916 0.75330245 -0.6376761 -0.6979239 0.60617656 0.5587962 -0.72547394 0.6592509 -0.50702363 -0.67814827 0.5920378 0.7109617 0.571823 0.47638968 0.45629972 0.7114783 0.67500675 0.80177283 0.3950372 -0.58267176 0.7896488 0.8001562 -0.5508178 0.71823895 0.541118 0.63710994 0.47948545 0.7575271 -0.41246787 -0.73996747 -0.56369996 0.5792697 -0.48852623 0.746355 -0.6310181 -0.42561933 0.5830349 0.720569 -0.40560526 0.65802425 0.4979452 -0.53672105 -0.57733256 0.44779927 0.7981319 -0.5407768 -0.6064364 -0.4186923 0.7415474 -0.57497007 -0.6405695 -0.6284303 0.5575207 -0.5271841 -0.55716383 0.55525804 0.51832956 -0.3524589 -0.6726228 -0.7866302 -0.6439635 0.61274445 0.45057285 0.7202019 -0.6529309 -0.6983464 0.44644594 0.62677187 -0.49503174; -0.79187906 -0.7843938 0.42532992 -0.6273086 -0.7761368 0.45274603 -0.47274047 -0.73221487 -0.7595088 -0.59987664 0.70501363 0.7267339 -0.4392104 0.47546014 0.5053776 -0.68740624 -0.6946016 0.5046609 -0.730506 0.5427167 0.6035872 -0.50105155 -0.5860077 0.60881233 -0.6989696 -0.6948554 -0.6880737 0.48752546 -0.65789574 -0.4043741 0.5591772 0.6557501 -0.71665186 0.7856982 -0.6666451 0.73022497 -0.7914387 0.5421285 -0.6051526 0.6230014 0.7336594 0.59062093 -0.6024163 0.724293 -0.48888403 0.64463854 -0.71103996 -0.7277127 0.6378562 0.7825355 0.54695415 -0.6073923 0.76863396 0.67665637 -0.6237595 -0.5945546 0.66350925 0.7554458 -0.48106074 -0.478911 0.5980163 0.6005307 0.66446674 -0.79046434 0.43463752 0.6566761 -0.6043567 -0.42701933 0.7523768 0.4491575 0.77609056 0.52367693 -0.8034524 -0.5951888 -0.6407028 0.51666313 0.674864 -0.73458636 -0.42187858 0.73234713], bias = Float32[-0.57672924; -0.64194745; -0.5714587; -0.9204308; -0.6011609; 0.5936967; -0.5444203; -0.66897804; 0.6031881; 0.59627867; -0.6235987; -0.5229289; 0.6047508; 0.6417289; -0.5795911; 0.6409867; 0.628845; 0.5693645; 0.6976153; 0.57214934; 0.53713214; 0.41438994; -0.44223848; -0.60121727; -0.5522123; 0.5645381; 0.56032914; 0.62548304; 0.62642014; 0.56660044; -0.5993617; 0.6337454; 0.6700317; -0.6217591; -0.61159486; 0.63000065; -0.5745414; 0.59844273; 0.6232421; -0.599301; -0.59039587; 0.5376928; 0.6001196; 0.56869036; -0.6109759; 0.5794728; -0.65013456; -0.60633856; 0.6568085; 0.6193528; -0.60324556; -0.65893835; -0.57099015; -0.61442024; 0.62503386; -0.5992237; 0.58557963; -0.6309461; 0.6060154; 0.60088915; 0.6243175; 0.5872848; 0.6198842; 0.50271654; 0.5816272; 0.60167146; -0.6599536; 0.5789793; -0.5734537; -0.6517569; -0.49574885; 0.6371207; -0.58071446; -0.60404176; -0.59847164; -0.5738589; -0.17984462; 0.5577196; -0.5888211; 0.6038177]), layer_3 = (weight = Float32[-0.54052234 1.0271597 0.09210778 -0.64353865 -0.45423436 0.5131243 -0.59373665 -0.72954285 0.46341652 0.49614665 -0.6683972 -0.48552093 0.32674995 -0.56689495 -0.37936804 0.5570589 0.661028 0.21153389 -0.2765669 0.25072116 0.3059074 0.83217275 0.8075577 -0.45407844 -0.37642866 0.5109157 0.4143954 -0.6165053 0.4486933 0.4698999 -0.50181687 0.13758774 -0.4885022 0.7479155 0.6628227 0.6468567 0.69525826 -0.7827009 0.33560342 -0.36778298 -0.4726986 0.41875157 0.3957739 0.5326938 -0.47514394 -0.61788654 0.7202094 0.72710925 -0.4593047 -0.7726181 -0.53015167 0.6412712 -0.5046769 0.76129633 0.6975157 -0.3721812 -0.6503444 -0.70318234 0.37132895 -0.7594479 -0.77824366 -0.39015535 -0.76377016 -0.723015 -0.7804873 0.42777568 0.3142564 0.3889767 -0.44999135 0.6461353 0.7444097 -0.34265754 -0.43140113 -0.5097927 -0.37839687 0.56696886 0.26824278 -0.52981424 0.74948895 -0.574976; -0.4290939 0.56508964 -1.162862 -0.5392717 -0.6544392 0.5763792 -0.3983037 -0.33347064 0.5268743 0.68546814 -0.3126288 -0.49131894 0.67244977 -0.76209205 -0.45848474 -0.6289348 0.3200917 0.6770646 -0.9453183 0.8632167 0.6846524 -1.0782754 0.3121352 -0.4381145 -0.6744919 0.7007211 0.66538596 -0.6500053 0.6422565 0.7327966 -0.6372259 0.69197345 -0.76902574 0.5441906 0.5284591 0.40035298 0.7315694 -0.83884984 0.6060992 -0.32852995 -0.5276525 0.4421085 0.35104814 0.85693586 -0.56978714 -0.5689479 0.7490586 0.520983 -0.7934366 0.4246105 -0.37773287 0.5902201 -0.43392536 0.7580938 0.399102 -0.31429234 -0.79630107 -0.35531378 0.59463763 -0.8806493 -0.5590195 -1.0268098 -0.5043635 -0.4368501 -0.65682304 0.37423158 0.898824 0.5757205 -0.6952836 0.8170003 0.42456144 -0.93815196 -0.65737534 -0.3074402 -0.48153752 0.7994504 0.3046598 -0.8692434 0.4610352 -0.707617], bias = Float32[-0.57128596; -0.6232511]))
function loss_neuralode(p)
    pred = predict_neuralode(p)
    loss = sum(abs2, true_data .- pred)   
    return loss, pred
end

loss_neuralode(p)[1]
 
